<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class EducationHistory extends Migration
{
	public function up()
	{
		// Membuat kolom/field untuk tabel education_history
		$this->forge->addField([
			'id'          => [
				'type'           => 'INT',
				'constraint'     => 11,
				'unsigned'       => true,
				'auto_increment' => true
			],
			'jenjang'       => [
				'type'           => 'ENUM',
				'constraint'     => ['SD', 'SMP', 'SMA', 'S1', 'S2', 'S3'],
				'null'           => false
			],
			'nama_sekolah'      => [
				'type'           => 'VARCHAR',
				'constraint'     => '255',
				'null'           => false,
			],
			'jurusan' => [
				'type'           => 'VARCHAR',
				'constraint'     => '100',
				'null'           => true,
			],
			'tahun_mulai'      => [
				'type'           => 'YEAR',
				'null'           => true,
			],
			'tahun_selesai'      => [
				'type'           => 'YEAR',
				'null'           => true,
			],
			'ipk'      => [
				'type'           => 'DECIMAL',
				'constraint'     => '3,2',
				'null'           => true,
			],
			'keterangan'      => [
				'type'           => 'TEXT',
				'null'           => true,
			],
			'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
			'updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
		]);

		// Membuat primary key
		$this->forge->addKey('id', TRUE);

		// Membuat tabel education_history
		$this->forge->createTable('education_history', TRUE);
	}

	//---------------------

	public function down()
	{
		// menghapus tabel education_history
		$this->forge->dropTable('education_history');
	}
}







