<?php

namespace App\Controllers;

use CodeIgniter\Controller;

class TestUpload extends Controller
{
    public function index()
    {
        $uploadDir = FCPATH . 'uploads/profile/';
        
        // Create directory if not exists
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $data = [
            'uploadDir' => $uploadDir,
            'dirExists' => is_dir($uploadDir),
            'dirWritable' => is_writable($uploadDir),
            'maxUpload' => ini_get('upload_max_filesize'),
            'maxPost' => ini_get('post_max_size'),
            'fileUploads' => ini_get('file_uploads')
        ];
        
        return view('test_upload', $data);
    }
    
    public function upload()
    {
        $uploadDir = FCPATH . 'uploads/profile/';
        
        // Get the uploaded file
        $file = $this->request->getFile('photo');
        
        $result = [
            'success' => false,
            'message' => '',
            'details' => []
        ];
        
        if (!$file) {
            $result['message'] = 'No file uploaded';
            return $this->response->setJSON($result);
        }
        
        $result['details']['original_name'] = $file->getName();
        $result['details']['size'] = $file->getSize();
        $result['details']['type'] = $file->getMimeType();
        $result['details']['is_valid'] = $file->isValid();
        $result['details']['has_moved'] = $file->hasMoved();
        $result['details']['error'] = $file->getError();
        $result['details']['error_string'] = $file->getErrorString();
        
        if (!$file->isValid()) {
            $result['message'] = 'Invalid file: ' . $file->getErrorString();
            return $this->response->setJSON($result);
        }
        
        if ($file->hasMoved()) {
            $result['message'] = 'File has already been moved';
            return $this->response->setJSON($result);
        }
        
        // Validate file type
        $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        if (!in_array($file->getMimeType(), $allowedTypes)) {
            $result['message'] = 'Invalid file type: ' . $file->getMimeType();
            return $this->response->setJSON($result);
        }
        
        // Generate new name
        $newName = $file->getRandomName();
        $result['details']['new_name'] = $newName;
        $result['details']['target_path'] = $uploadDir . $newName;
        
        try {
            if ($file->move($uploadDir, $newName)) {
                $result['success'] = true;
                $result['message'] = 'File uploaded successfully';
                $result['details']['web_path'] = base_url('uploads/profile/' . $newName);
            } else {
                $result['message'] = 'Failed to move file: ' . $file->getErrorString();
            }
        } catch (\Exception $e) {
            $result['message'] = 'Exception: ' . $e->getMessage();
        }
        
        return $this->response->setJSON($result);
    }
}