<?php

namespace App\Controllers;

use App\Models\EducationHistoryModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Education extends BaseController
{
	public function index()
	{
		$model = new EducationHistoryModel();
		
		// Get search parameter
		$search = $this->request->getGet('search');
		
		// Get filter parameters
		$filter_jenjang = $this->request->getGet('filter_jenjang');
		
		// Get sorting parameters
		$sort_by = $this->request->getGet('sort_by') ?? 'tahun_mulai';
		$sort_order = $this->request->getGet('sort_order') ?? 'DESC';
		
		// Apply search
		if (!empty($search)) {
			$model->groupStart()
				->like('nama_sekolah', $search)
				->orLike('jurusan', $search)
				->groupEnd();
		}
		
		// Apply filter
		if (!empty($filter_jenjang)) {
			$model->where('jenjang', $filter_jenjang);
		}
		
		// Apply sorting
		$model->orderBy($sort_by, $sort_order);
		
		// Get paginated results (10 per page)
		$data = [
			'educations' => $model->paginate(10),
			'pager' => $model->pager,
			'search' => $search,
			'filter_jenjang' => $filter_jenjang,
			'sort_by' => $sort_by,
			'sort_order' => $sort_order,
		];
		
		echo view('education', $data);
	}
}

