# Education Admin Test Guide

## Steps to Test Education Admin Functionality

### 1. Start the Development Server
```bash
php spark serve --host=localhost --port=8080
```

### 2. Login to Admin Panel
1. Go to: `http://localhost:8080/admin/login`
2. Login with:
   - **Username**: `dodi`
   - **Password**: `Dodi123`

### 3. Access Education Management
1. After login, go to: `http://localhost:8080/admin/education`
2. You should see the education management page with existing data

### 4. Test Add New Education
1. Click the "Tambah Pendidikan" button
2. Or go directly to: `http://localhost:8080/admin/education/create`
3. Fill in the form:
   - **Jenjang**: Choose from dropdown (SD, SMP, SMA, S1, S2, S3)
   - **Nama Sekolah**: Enter school/university name
   - **Jurusan**: Enter major/program (optional)
   - **Tahun Mulai**: Enter start year
   - **Tahun Selesai**: Enter end year
   - **IPK**: Enter GPA (optional)
   - **Keterangan**: Enter additional notes (optional)
4. Click "Simpan" to save

### 5. Test Edit Education
1. From the education list, click the edit button (pencil icon) next to any record
2. Or go to: `http://localhost:8080/admin/education/[ID]/edit` (replace [ID] with actual ID)
3. Modify the data and click "Update Pendidikan"

## Troubleshooting

### If you get 404 errors:
1. Make sure you're logged in to admin panel first
2. Check that the URL is correct
3. Verify the development server is running

### If you get authentication errors:
1. Clear browser cookies and try logging in again
2. Make sure you're using the correct credentials

### If forms don't work:
1. Check browser console for JavaScript errors
2. Verify CSRF tokens are working
3. Check that all required fields are filled

## System Status
- ✅ Database migrations: Complete
- ✅ Education seeder: Complete  
- ✅ Routes configuration: Complete
- ✅ Controller methods: Complete
- ✅ View files: Complete
- ✅ Model: Complete
- ✅ Authentication: Complete

The education admin system is fully functional and ready to use!