# Konten Presentasi Proyek: MyProfile (Porto Andi)

Dokumen ini berisi materi untuk slide presentasi PowerPoint (PPT) mengenai proyek "MyProfile".

---

## Slide 1: Judul Proyek
**Judul:** MyProfile - Personal Portfolio Platform
**Sub-judul:** Membangun Branding Personal dengan Teknologi Web Modern
**Presenter:** [Nama Anda]
**Posisi/Role:** Web Developer / Mahasiswa

---

## Slide 2: Latar Belakang & Tujuan
**Masalah:**
- Kesulitan mengelola portfolio personal yang statis (HTML/CSS biasa).
- Kebutuhan akan wadah profesional untuk menampilkan riwayat pendidikan dan aktivitas terbaru secara *real-time*.

**Solusi:**
- **MyProfile**: Sebuah aplikasi web dinamis yang memungkinkan pengguna mengelola data diri, riwayat pendidikan, dan portfolio aktivitas melalui panel admin yang mudah digunakan.

**Tujuan:**
- Memberikan impresi profesional kepada rekruter atau klien.
- Kemudahan pengelolaan konten tanpa menyentuh kode program (coding).

---

## Slide 3: Fitur Utama (Frontend - Publik)
Halaman yang dapat diakses oleh pengunjung umum:

1.  **Biodata Diri**:
    - Menampilkan profil singkat, foto, dan informasi kontak.
    - Integrasi tautan sosial media (GitHub, LinkedIn, Instagram, Twitter/X).
2.  **Riwayat Pendidikan**:
    - Timeline pendidikan formal dan non-formal.
    - Informasi institusi, tahun masuk/lulus, dan deskripsi.
3.  **Aktivitas & Portfolio**:
    - Galeri proyek dengan layout **Masonry Grid** yang responsif.
    - Detail aktivitas ditampilkan dalam **Interactive Modals**.

---

## Slide 4: Fitur Utama (Backend - Admin)
Fitur untuk pengelola website (Hanya akses Admin):

1.  **Sistem Autentikasi Aman**:
    - Login menggunakan username dan password terenkripsi.
    - Proteksi route admin (Middleware/Filters) untuk mencegah akses tanpa izin.
2.  **Manajemen Konten (CRUD)**:
    - **Biodata**: Update informasi profil dan link sosmed.
    - **Pendidikan**: Tambah, Edit, Hapus data pendidikan.
    - **Aktivitas**: Tambah, Edit, Hapus postingan aktivitas.
3.  **Dashboard**: Ringkasan status data.

---

## Slide 5: Teknologi yang Digunakan (Tech Stack)
Aplikasi ini dibangun dengan teknologi modern yang cepat dan aman:

*   **Backend Framework:** CodeIgniter 4 (PHP)
    *   *Alasan:* Performa tinggi (Lightweight), keamanan bawaan, dan arsitektur MVC yang rapi.
*   **Database:** MySQL
    *   *Alasan:* Standar industri untuk penyimpanan data relasional yang handal.
*   **Frontend Styles:** Bootstrap 5 + Custom CSS
    *   *Desain:* Menggunakan gaya "**Glassmorphism**" (efek kaca transparan) dengan **Hero Section** modern.
    *   *Font:* Google Fonts (Plus Jakarta Sans) untuk keterbacaan yang baik.
*   **Icons:** Bootstrap Icons.

---

## Slide 6: Arsitektur Sistem
Menggunakan pola **MVC (Model-View-Controller)**:

1.  **Model (`app/Models`)**:
    - Berinteraksi langsung dengan Database (CRUD).
    - Contoh: `BiodataModel`, `PendidikanModel`, `AktivitasModel`.
2.  **View (`app/Views`)**:
    - Menangani tampilan antarmuka pengguna (UI).
    - Memisahkan layout utama (`template.php`) dan konten halaman.
3.  **Controller (`app/Controllers`)**:
    - Otak aplikasi yang menghubungkan Model dan View.
    - Mengatur logika bisnis dan alur data.

---

## Slide 7: Desain & Tampilan
**Konsep Visual:** Premium & Modern Professional.
- **Glassmorphism**: UI elemen menggunakan efek blur/transparan yang elegan.
- **Improved UX**:
    - **Vertical Timeline** untuk visualisasi riwayat pendidikan yang lebih jelas.
    - **Masonry Card Grid** untuk tampilan aktivitas yang dinamis.
    - **Hero Section** dengan animasi halus (`fade-in-up`) untuk impresi pertama yang kuat.
- **Responsif**: Tampilan menyesuaikan sempurna di Desktop, Tablet, dan Mobile.

---

## Slide 8: Kesimpulan
**MyProfile** adalah solusi lengkap untuk personal branding digital.
- **Efisien**: Pengelolaan data cepat via Admin Panel.
- **Menarik**: Desain visual yang kekinian dan profesional.
- **Scalable**: Struktur kode yang rapi (CodeIgniter 4) memudahkan pengembangan fitur lanjut di masa depan.

---

## Sesi Tanya Jawab (Q&A)
Terima kasih. Apakah ada pertanyaan?
