<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<div class="row justify-content-center">
    <!-- Header -->
    <div class="col-lg-10 text-center mb-5 fade-in-up">
        <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-2 border border-primary border-opacity-25 mb-3">Academic Background</span>
        <h1 class="fw-bold display-5 mb-3">Pendidikan & <span class="text-gradient">Akademik</span></h1>
        <p class="text-muted lead mx-auto" style="max-width: 600px;">
            Perjalanan pendidikan formal yang membentuk dasar pengetahuan dan keahlian saya.
        </p>
    </div>

    <!-- Filter & Content -->
    <div class="col-lg-10">
        <!-- Search & Filter Bar -->
        <div class="card glass rounded-pill mb-5 border-0 fade-in-up delay-100 p-2 shadow-sm">
            <div class="card-body p-1">
                <form action="<?= base_url('/pendidikan'); ?>" method="get" class="d-flex flex-column flex-md-row gap-2">
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-0 ps-3"><i class="bi bi-search text-muted"></i></span>
                        <input type="text" class="form-control border-0 bg-transparent shadow-none" name="keyword" placeholder="Cari Sekolah/Universitas..." value="<?= esc($keyword); ?>">
                    </div>
                    
                    <div class="d-flex gap-2">
                        <select class="form-select border-0 bg-light rounded-pill" style="min-width: 150px;" name="jenjang">
                            <option value="">Semua Jenjang</option>
                            <option value="SD" <?= $jenjang == 'SD' ? 'selected' : ''; ?>>SD</option>
                            <option value="SMP" <?= $jenjang == 'SMP' ? 'selected' : ''; ?>>SMP</option>
                            <option value="SMA" <?= $jenjang == 'SMA' ? 'selected' : ''; ?>>SMA</option>
                            <option value="Kuliah" <?= $jenjang == 'Kuliah' ? 'selected' : ''; ?>>Kuliah</option>
                        </select>
                        
                         <select class="form-select border-0 bg-light rounded-pill" style="min-width: 140px;" name="order">
                            <option value="DESC" <?= $order == 'DESC' ? 'selected' : ''; ?>>Terbaru</option>
                            <option value="ASC" <?= $order == 'ASC' ? 'selected' : ''; ?>>Terlama</option>
                        </select>
                        
                        <button type="submit" class="btn btn-primary rounded-pill px-4"><i class="bi bi-arrow-right"></i></button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Timeline -->
        <div class="fade-in-up delay-200">
            <?php if(empty($pendidikan)): ?>
                 <div class="text-center py-5 glass rounded-4 border-0">
                    <div class="mb-3">
                         <i class="bi bi-journal-x fs-1 text-muted opacity-50"></i>
                    </div>
                    <h5 class="text-muted">Tidak ada data pendidikan ditemukan.</h5>
                    <a href="<?= base_url('/pendidikan'); ?>" class="btn btn-link text-decoration-none">Reset Filter</a>
                </div>
            <?php else: ?>
                <div class="timeline">
                    <?php foreach($pendidikan as $edu): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker shadow-sm">
                                <i class="bi bi-mortarboard-fill"></i>
                            </div>
                            <div class="card glass hover-card border-0 rounded-4 ms-3">
                                <div class="card-body p-4">
                                    <div class="row align-items-center">
                                        <div class="col-md-9">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill me-2"><?= esc($edu['jenjang']); ?></span>
                                                <small class="text-muted fw-bold"><i class="bi bi-calendar3 me-1"></i> <?= esc($edu['tahun_masuk']); ?> - <?= esc($edu['tahun_lulus']); ?></small>
                                            </div>
                                            <h4 class="fw-bold mb-1"><?= esc($edu['nama_sekolah']); ?></h4>
                                            <!-- You could add a description field here if your DB has one -->
                                            <p class="text-muted mb-0 small opacity-75">Graduated with honors / description placeholder.</p> 
                                        </div>
                                        <div class="col-md-3 text-md-end mt-3 mt-md-0">
                                            <div class="bg-light rounded-3 p-2 d-inline-block text-center" style="min-width: 80px;">
                                                <span class="d-block small text-muted text-uppercase">Tahun</span>
                                                <span class="d-block fw-bold fs-5"><?= esc($edu['tahun_lulus']); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-5 d-flex justify-content-center">
                    <?= $pager->links('pendidikan', 'default_full'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>
