<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?? 'My App'; ?></title>
    <link rel="icon" href="https://fav.farm/👨‍💻" />
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- Google Fonts: Plus Jakarta Sans -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
      :root {
        --primary-color: #4f46e5; /* Indigo 600 */
        --primary-light: #818cf8; /* Indigo 400 */
        --secondary-color: #ec4899; /* Pink 500 */
        --bg-gradient-start: #f8fafc;
        --bg-gradient-end: #e2e8f0;
        --card-bg: rgba(255, 255, 255, 0.85);
        --glass-border: rgba(255, 255, 255, 0.4);
      }

      body {
        font-family: 'Plus Jakarta Sans', sans-serif;
        background: linear-gradient(135deg, var(--bg-gradient-start) 0%, var(--bg-gradient-end) 100%);
        min-height: 100vh;
        color: #334155;
      }

      /* Glassmorphism Utilities */
      .glass {
        background: var(--card-bg);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border: 1px solid var(--glass-border);
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.07);
      }
      
      .glass-nav {
         background: rgba(255, 255, 255, 0.7);
         backdrop-filter: blur(20px);
         border-bottom: 1px solid rgba(255,255,255,0.3);
         box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.01);
      }

      /* Typography & Gradients */
      .text-gradient {
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
      }
      
      .bg-gradient-primary-soft {
        background: linear-gradient(135deg, rgba(79, 70, 229, 0.1) 0%, rgba(236, 72, 153, 0.1) 100%);
      }

      /* Card Hover Effects */
      .hover-card {
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      }
      .hover-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px -5px rgba(0,0,0,0.1);
        border-color: rgba(255,255,255,0.8);
      }

      /* Timeline Component */
      .timeline {
        position: relative;
        padding-left: 3rem;
      }
      .timeline::before {
        content: '';
        position: absolute;
        left: 15px;
        top: 0;
        bottom: 0;
        width: 3px;
        background: linear-gradient(to bottom, var(--primary-light), var(--secondary-color));
        border-radius: 3px;
        opacity: 0.3;
      }
      .timeline-item {
        position: relative;
        margin-bottom: 2.5rem;
      }
      .timeline-marker {
        position: absolute;
        left: -3rem;
        top: 0.5rem;
        width: 32px;
        height: 32px;
        background: var(--card-bg);
        border: 2px solid var(--primary-color);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1;
      }
      .timeline-marker i {
        font-size: 0.8rem;
        color: var(--primary-color);
      }

      /* Animations */
      @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
      }
      
      .fade-in-up {
        animation: fadeIn 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
      }
      
      .delay-100 { animation-delay: 0.1s; }
      .delay-200 { animation-delay: 0.2s; }
      .delay-300 { animation-delay: 0.3s; }
      
      /* Utilities */
      .object-fit-cover { object-fit: cover; }
      .rounded-5 { border-radius: 2rem !important; }
      
      /* Bento Grid Styles */
      .bento-grid-container {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        grid-auto-rows: minmax(150px, auto);
        gap: 1.5rem;
        max-width: 1400px;
        margin: 0 auto;
        padding: 2rem 0;
      }
      
      .bento-card {
        border-radius: 1.5rem;
        padding: 2rem;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
      }
      
      .bento-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(79, 70, 229, 0.05) 0%, rgba(236, 72, 153, 0.05) 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
        pointer-events: none;
      }
      
      .bento-card:hover::before {
        opacity: 1;
      }
      
      .bento-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.12);
      }
      
      /* Grid Layout */
      .bento-profile {
        grid-column: span 1;
        grid-row: span 2;
        text-align: center;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      
      .bento-about {
        grid-column: span 2;
        grid-row: span 2;
      }
      
      .bento-stat {
        grid-column: span 1;
        grid-row: span 1;
        text-align: center;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      
      .bento-contact {
        grid-column: span 2;
        grid-row: span 1;
      }
      
      .bento-skills {
        grid-column: span 2;
        grid-row: span 1;
      }
      
      .bento-cta {
        grid-column: span 2;
        grid-row: span 1;
      }
      
      /* Profile Card Styles */
      .bento-profile-img {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        object-fit: cover;
        border: 4px solid rgba(255,255,255,0.8);
        box-shadow: 0 10px 40px rgba(79, 70, 229, 0.3);
        position: relative;
        z-index: 2;
      }
      
      .profile-glow {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, rgba(79, 70, 229, 0.4) 0%, transparent 70%);
        border-radius: 50%;
        animation: pulse 3s ease-in-out infinite;
        z-index: 1;
      }
      
      @keyframes pulse {
        0%, 100% { transform: translate(-50%, -50%) scale(1); opacity: 0.5; }
        50% { transform: translate(-50%, -50%) scale(1.1); opacity: 0.8; }
      }
      
      .social-links-compact {
        display: flex;
        gap: 0.5rem;
        justify-content: center;
        margin-top: 1rem;
      }
      
      .social-btn {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(255,255,255,0.5);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #4f46e5;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 1px solid rgba(79, 70, 229, 0.2);
      }
      
      .social-btn:hover {
        background: #4f46e5;
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(79, 70, 229, 0.3);
      }
      
      /* Card Header */
      .bento-card-header {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 1rem;
      }
      
      .bento-card-header i {
        font-size: 1.5rem;
      }
      
      /* Stats Cards */
      .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.8rem;
        margin-bottom: 1rem;
        background: rgba(255,255,255,0.5);
      }
      
      .stat-blue .stat-icon {
        background: linear-gradient(135deg, #3b82f6, #2563eb);
        color: white;
      }
      
      .stat-purple .stat-icon {
        background: linear-gradient(135deg, #8b5cf6, #6366f1);
        color: white;
      }
      
      .stat-green .stat-icon {
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
      }
      
      .stat-number {
        font-size: 3rem;
        font-weight: 700;
        margin: 0.5rem 0;
        line-height: 1;
      }
      
      .stat-blue .stat-number { color: #3b82f6; }
      .stat-purple .stat-number { color: #8b5cf6; }
      .stat-green .stat-number { color: #10b981; }
      
      .stat-label {
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: #64748b;
        margin: 0;
        font-weight: 500;
      }
      
      /* Contact Items */
      .contact-item {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1rem;
        background: rgba(255,255,255,0.3);
        border-radius: 0.75rem;
        margin-bottom: 0.75rem;
        transition: all 0.3s ease;
      }
      
      .contact-item:last-child {
        margin-bottom: 0;
      }
      
      .contact-item:hover {
        background: rgba(255,255,255,0.5);
        transform: translateX(5px);
      }
      
      .contact-item i {
        font-size: 1.5rem;
        color: #4f46e5;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(79, 70, 229, 0.1);
        border-radius: 0.5rem;
      }
      
      /* Skills Grid */
      .skills-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 0.75rem;
      }
      
      .skill-tag {
        padding: 0.5rem 1rem;
        background: linear-gradient(135deg, rgba(79, 70, 229, 0.1), rgba(236, 72, 153, 0.1));
        border: 1px solid rgba(79, 70, 229, 0.2);
        border-radius: 2rem;
        font-size: 0.9rem;
        font-weight: 500;
        color: #4f46e5;
        transition: all 0.3s ease;
      }
      
      .skill-tag:hover {
        background: linear-gradient(135deg, #4f46e5, #ec4899);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(79, 70, 229, 0.3);
      }
      
      /* CTA Card */
      .cta-content {
        text-align: center;
      }
      
      /* Responsive Design */
      @media (max-width: 1200px) {
        .bento-grid-container {
          grid-template-columns: repeat(3, 1fr);
        }
        
        .bento-profile { grid-column: span 1; }
        .bento-about { grid-column: span 2; }
        .bento-stat { grid-column: span 1; }
        .bento-contact { grid-column: span 3; }
        .bento-skills { grid-column: span 3; }
        .bento-cta { grid-column: span 3; }
      }
      
      @media (max-width: 768px) {
        .bento-grid-container {
          grid-template-columns: 1fr;
          gap: 1rem;
        }
        
        .bento-card {
          grid-column: span 1 !important;
          grid-row: span 1 !important;
          padding: 1.5rem;
        }
        
        .bento-profile-img {
          width: 150px;
          height: 150px;
        }
        
        .stat-number {
          font-size: 2.5rem;
        }
      }
    
    </style>
  </head>
  <body>
    
    <?= $this->include('layout/navbar'); ?>

    <div class="container py-5 mt-5">
        <?php if(session()->getFlashdata('message')) : ?>
            <div class="alert alert-success" role="alert">
                <?= session()->getFlashdata('message'); ?>
            </div>
        <?php endif; ?>
         <?= $this->renderSection('content'); ?>
    </div>

    <footer class="mt-auto py-5 glass border-top border-light">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-4 col-md-6 mb-4 mb-md-0">
                    <h5 class="text-primary fw-bold mb-3"><i class="bi bi-person-badge-fill me-2"></i>MyProfile</h5>
                    <p class="text-muted small">
                        Platform personal untuk menampilkan biodata, riwayat pendidikan, dan catatan aktivitas harian secara profesional dan modern.
                    </p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4 mb-md-0">
                    <h6 class="text-uppercase fw-bold mb-3 small text-secondary">Menu</h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2"><a href="<?= base_url('/'); ?>" class="text-muted text-decoration-none small hover-link">Biodata</a></li>
                        <li class="mb-2"><a href="<?= base_url('/pendidikan'); ?>" class="text-muted text-decoration-none small hover-link">Pendidikan</a></li>
                        <li class="mb-2"><a href="<?= base_url('/aktivitas'); ?>" class="text-muted text-decoration-none small hover-link">Aktivitas</a></li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
                    <h6 class="text-uppercase fw-bold mb-3 small text-secondary">Connect</h6>
                    <?php 
                        // Fetch social links directly for layout
                        $dbBiodata = (new \App\Models\BiodataModel())->first();
                    ?>
                    <div class="d-flex gap-3">
                        <?php if(!empty($dbBiodata['link_github'])): ?>
                            <a href="<?= $dbBiodata['link_github']; ?>" target="_blank" class="text-secondary fs-5 hover-scale"><i class="bi bi-github"></i></a>
                        <?php endif; ?>
                        <?php if(!empty($dbBiodata['link_linkedin'])): ?>
                            <a href="<?= $dbBiodata['link_linkedin']; ?>" target="_blank" class="text-primary fs-5 hover-scale"><i class="bi bi-linkedin"></i></a>
                        <?php endif; ?>
                        <?php if(!empty($dbBiodata['link_instagram'])): ?>
                            <a href="<?= $dbBiodata['link_instagram']; ?>" target="_blank" class="text-danger fs-5 hover-scale"><i class="bi bi-instagram"></i></a>
                        <?php endif; ?>
                        <?php if(!empty($dbBiodata['link_twitter'])): ?>
                            <a href="<?= $dbBiodata['link_twitter']; ?>" target="_blank" class="text-info fs-5 hover-scale"><i class="bi bi-twitter-x"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                 <div class="col-lg-3 col-md-6">
                    <h6 class="text-uppercase fw-bold mb-3 small text-secondary">Newsletter</h6>
                    <p class="text-muted small mb-3">Dapatkan update terbaru.</p>
                     <div class="input-group mb-3">
                        <input type="text" class="form-control form-control-sm" placeholder="Email address" aria-label="Email">
                        <button class="btn btn-primary btn-sm" type="button"><i class="bi bi-send"></i></button>
                    </div>
                </div>
            </div>
            
            <hr class="my-4 opacity-25">
            
            <div class="text-center text-muted small">
                &copy; <?= date('Y'); ?> MyProfile. Built with CodeIgniter 4 & Bootstrap 5.
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
      function confirmDelete() {
        return confirm("Are you sure you want to delete this item?");
      }
    </script>
  </body>
</html>
