<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>
<style>
.article-content {
    font-size: clamp(1rem, 1.15vw, 1.1rem);
    line-height: 1.75;
    color: var(--text-primary);
}
.article-content h1,
.article-content h2,
.article-content h3,
.article-content h4 {
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
    font-weight: 700;
    color: var(--brand-dark);
}
.article-content h2 {
    font-size: clamp(1.5rem, 2vw, 1.85rem);
}
.article-content h3 {
    font-size: clamp(1.3rem, 1.7vw, 1.6rem);
}
.article-content p {
    margin-bottom: 1.2rem;
}
.article-content img {
    max-width: 100%;
    height: auto;
    border-radius: 12px;
    margin: 1.5rem 0;
}
.card-body h2 {
    font-size: clamp(24px, 3.5vw, 32px);
    font-weight: 700;
    line-height: 1.3;
    color: var(--brand-dark);
}
@media (max-width: 768px) {
    .card-body {
        padding: 1.5rem !important;
    }
    .card-body h2 {
        font-size: 22px !important;
    }
    .article-content {
        font-size: 1rem;
    }
}
@media (max-width: 576px) {
    .card-body {
        padding: 1.2rem !important;
    }
    .card-body h2 {
        font-size: 20px !important;
    }
    .article-content {
        font-size: 0.95rem;
        line-height: 1.7;
    }
    .article-content img {
        margin: 1rem 0;
    }
}

/* ============================================
   ANIMASI SMOOTH UNTUK NEWS DETAIL
   ============================================ */

@keyframes newsDetailFadeIn {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes newsImageZoom {
    from {
        opacity: 0;
        transform: scale(1.05);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

article.card {
    animation: newsDetailFadeIn 0.6s ease-out;
}

.card-body h2 {
    animation: newsDetailFadeIn 0.6s ease-out 0.2s both;
}

.card-body .text-muted {
    animation: newsDetailFadeIn 0.5s ease-out 0.3s both;
}

.card-body img {
    animation: newsImageZoom 0.8s ease-out 0.4s both;
    transition: transform 0.5s ease, filter 0.5s ease;
}

.card-body:hover img {
    transform: scale(1.02);
    filter: brightness(1.05);
}

.article-content {
    animation: newsDetailFadeIn 0.6s ease-out 0.5s both;
}

.article-content p {
    animation: newsDetailFadeIn 0.4s ease-out both;
}

.article-content p:nth-child(1) { animation-delay: 0.6s; }
.article-content p:nth-child(2) { animation-delay: 0.7s; }
.article-content p:nth-child(3) { animation-delay: 0.8s; }
.article-content p:nth-child(4) { animation-delay: 0.9s; }

.article-content h2,
.article-content h3 {
    animation: newsDetailFadeIn 0.5s ease-out both;
    transition: color 0.3s ease;
}

.article-content h2:hover,
.article-content h3:hover {
    color: var(--brand-primary);
}

.article-content img {
    transition: transform 0.5s ease, box-shadow 0.5s ease;
}

.article-content img:hover {
    transform: scale(1.02);
    box-shadow: 0 12px 32px rgba(15, 23, 42, 0.15);
}

@media (prefers-reduced-motion: reduce) {
    article.card,
    .card-body h2,
    .card-body img,
    .article-content {
        animation: none !important;
    }
}
</style>
<article class="card shadow-sm">
    <div class="card-body">
        <h2 class="h3 mb-2"><?= esc($news['title']) ?></h2>
        <div class="text-muted small mb-3">
            <?php
                $createdAt = $news['created_at'] ?? null;
                if ($createdAt) {
                    $formattedDate = date('d M Y', strtotime($createdAt));
                    echo esc($formattedDate);
                } else {
                    echo 'Tanggal tidak diketahui';
                }
            ?>
        </div>
        <?php if (! empty($news['image_path'])): ?>
            <div class="mb-4 text-center">
                <img
                    src="<?= base_url($news['image_path']) ?>"
                    alt="<?= esc($news['title']) ?>"
                    class="img-fluid rounded shadow-sm"
                    style="max-height: 420px; object-fit: cover;">
            </div>
        <?php endif; ?>
        <div class="article-content">
            <?= esc($news['content'], 'html') ?>
        </div>
    </div>
</article>

<?= $this->endSection() ?>
