<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>
<?php
    $request    = service('request');
    $searchTerm = trim((string) $request->getGet('q'));
    $totalNews  = is_countable($newses ?? []) ? count($newses) : 0;
?>

<section class="news-filter">
    <form method="get">
        <div class="news-search">
            <span class="icon">🔍</span>
            <input
                type="search"
                name="q"
                value="<?= esc($searchTerm) ?>"
                placeholder="Cari judul, kata kunci, atau divisi terkait">
        </div>
        <button type="submit" class="btn btn-primary btn-filter">Cari Berita</button>
    </form>
    <div class="small text-muted mt-3">
        Menampilkan <?= esc($totalNews) ?> artikel <?= $searchTerm ? 'untuk pencarian “' . esc($searchTerm) . '”' : 'terbaru' ?>.
    </div>
</section>

<?php if ($totalNews === 0): ?>
    <div class="empty-state">
        Belum ada berita terbit. Silakan kembali lagi setelah tim mempublikasikan kabar terbaru.
    </div>
<?php else: ?>
    <div class="news-grid">
        <?php foreach ($newses as $news): ?>
            <?php
                $rawContent    = strip_tags($news['content'] ?? '');
                $excerpt       = mb_strlen($rawContent) > 180 ? mb_substr($rawContent, 0, 180) . '…' : $rawContent;
                $wordCount     = max(1, str_word_count($rawContent));
                $readingMinute = max(1, (int) ceil($wordCount / 190));
                $createdAt     = $news['created_at'] ?? null;
                $formattedDate = $createdAt ? date('d M Y', strtotime($createdAt)) : 'Tanggal tidak diketahui';
            ?>
            <article class="news-card">
                <?php if (! empty($news['image_path'])): ?>
                    <div class="news-card__media">
                        <img src="<?= esc(base_url($news['image_path'])) ?>" alt="<?= esc($news['title']) ?>" loading="lazy">
                    </div>
                <?php endif; ?>
                <div class="news-card__body">
                    <span class="home-meta">Berita Perusahaan</span>
                    <h3 class="news-card__title">
                        <a href="<?= base_url('news/' . $news['slug']) ?>">
                            <?= esc($news['title']) ?>
                        </a>
                    </h3>
                    <div class="news-card__meta">
                        <span><?= esc($formattedDate) ?></span>
                        <span><?= esc($readingMinute) ?> menit baca</span>
                    </div>
                    <p class="news-card__excerpt"><?= esc($excerpt) ?></p>
                    <a class="btn btn-link px-0 fw-semibold" href="<?= base_url('news/' . $news['slug']) ?>">
                        Baca selengkapnya →
                    </a>
                </div>
            </article>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>
