<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login - Admin</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet" />
    <?php
        $assetVersion = '20251215';
        $scriptDir     = trim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
        $assetBasePath = ($scriptDir !== '') ? '/' . $scriptDir . '/' : '/';
    ?>
    <style>
        :root {
            --bg: #0b1728;
            --bg-soft: #0f213a;
            --card: #ffffff;
            --text: #0f172a;
            --muted: #6b7280;
            --primary: #0ea5e9;
            --primary-soft: rgba(14, 165, 233, 0.12);
            --border: rgba(148, 163, 184, 0.35);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            background: linear-gradient(135deg, #0b1728 0%, #0f213a 50%, #0e1629 100%);
            color: var(--text);
            min-height: 100vh;
            display: grid;
            place-items: center;
            padding: 1.5rem;
            position: relative;
            overflow: hidden;
        }
        .bg-ornament {
            position: absolute;
            inset: 0;
            pointer-events: none;
            overflow: hidden;
        }
        .bg-ornament .glow {
            position: absolute;
            width: 260px;
            height: 260px;
            filter: blur(120px);
            opacity: 0.5;
        }
        .bg-ornament .glow.g1 { background: #0ea5e9; top: 5%; left: 10%; }
        .bg-ornament .glow.g2 { background: #14b8a6; bottom: 8%; right: 12%; }
        .bg-ornament .shape {
            position: absolute;
            width: 80px;
            height: 80px;
            border-radius: 20px;
            border: 1px solid rgba(255,255,255,0.12);
            background: rgba(255,255,255,0.02);
            transform: rotate(-6deg);
        }
        .bg-ornament .shape.s1 { top: 18%; right: 22%; }
        .bg-ornament .shape.s2 { bottom: 18%; left: 20%; width: 120px; height: 120px; }
        .shell {
            width: min(420px, 100%);
            position: relative;
            z-index: 1;
        }
        .brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 1rem;
            color: #e5e7eb;
        }
        .brand-mark {
            width: 42px;
            height: 42px;
            border-radius: 14px;
            background: linear-gradient(135deg, #0ea5e9, #0e7490);
            display: grid;
            place-items: center;
            font-weight: 700;
            color: #fff;
            letter-spacing: 0.04em;
        }
        .brand span {
            font-weight: 700;
            font-size: 1.05rem;
        }
        .card {
            background: var(--card);
            border-radius: 16px;
            padding: 1.75rem;
            box-shadow: 0 24px 48px rgba(6, 24, 45, 0.25);
            border: 1px solid var(--border);
        }
        .card h1 {
            margin: 0 0 0.35rem;
            font-size: 1.4rem;
        }
        .card p.lead {
            margin: 0 0 1.25rem;
            color: var(--muted);
        }
        .field {
            margin-bottom: 1rem;
            position: relative;
        }
        .field label {
            display: block;
            margin-bottom: 0.35rem;
            font-weight: 600;
            color: var(--text);
        }
        .field input {
            width: 100%;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: 0.75rem 0.9rem;
            font-size: 1rem;
            background: #f8fafc;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }
        .field input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px var(--primary-soft);
            background: #fff;
        }
        .error {
            display: flex;
            gap: 0.4rem;
            align-items: center;
            color: #b91c1c;
            font-size: 0.92rem;
            margin-top: 0.35rem;
        }
        .remember {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--muted);
            font-size: 0.95rem;
            margin: 0.5rem 0 1.25rem;
        }
        .btn {
            width: 100%;
            padding: 0.85rem;
            border-radius: 12px;
            border: none;
            background: linear-gradient(135deg, #0ea5e9, #0e7490);
            color: #fff;
            font-weight: 700;
            font-size: 1rem;
            cursor: pointer;
            transition: transform 0.15s ease, box-shadow 0.2s ease;
        }
        .btn:hover { transform: translateY(-1px); box-shadow: 0 14px 28px rgba(6, 24, 45, 0.2); }
        .btn:active { transform: translateY(0); }
        .supporting {
            margin-top: 1rem;
            color: var(--muted);
            font-size: 0.92rem;
            text-align: center;
        }
        .alert {
            background: rgba(16, 185, 129, 0.12);
            border: 1px solid rgba(16, 185, 129, 0.32);
            color: #0f5132;
            padding: 0.75rem 1rem;
            border-radius: 12px;
            display: flex;
            gap: 0.6rem;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        .alert svg { width: 18px; height: 18px; }
        .footer-note {
            text-align: center;
            color: #cbd5e1;
            font-size: 0.92rem;
            margin-top: 1rem;
        }
    </style>
</head>
<body>
    <div class="bg-ornament">
        <div class="glow g1"></div>
        <div class="glow g2"></div>
        <div class="shape s1"></div>
        <div class="shape s2"></div>
    </div>
    <div class="shell">
        <div class="brand">
            <div class="brand-mark">DC</div>
            <span>Dimas Cahya Ramadhan</span>
        </div>
        <div class="card">
            <h1>Masuk</h1>
            <p class="lead">Akses panel admin dengan kredensial terdaftar.</p>
            <?php
                $errors        = session()->getFlashdata('errors') ?? [];
                $message       = session()->getFlashdata('message');
                $emailError    = $errors['email'] ?? null;
                $passwordError = $errors['password'] ?? null;
                $loginError    = $errors['login'] ?? null;
                $isAssoc       = is_array($errors) && array_keys($errors) !== range(0, count($errors) - 1);
                if (! $isAssoc && ! empty($errors) && ! $loginError && ! $emailError && ! $passwordError) {
                    $loginError = reset($errors);
                }
            ?>
            <?php if ($message): ?>
                <div class="alert">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                        <path d="M20 6L9 17l-5-5"></path>
                    </svg>
                    <div><?= esc($message) ?></div>
                </div>
            <?php endif; ?>

            <form action="<?= $assetBasePath ?>login" method="post" novalidate>
                <?= csrf_field() ?>

                <div class="field">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" required value="<?= old('email') ?>" autocomplete="email" placeholder="nama@example.com">
                    <?php if ($emailError): ?>
                        <div class="error"><?= esc($emailError) ?></div>
                    <?php endif; ?>
                </div>

                <div class="field">
                    <label for="password">Kata sandi</label>
                    <input type="password" id="password" name="password" required autocomplete="current-password" placeholder="••••••••">
                    <?php if ($passwordError): ?>
                        <div class="error"><?= esc($passwordError) ?></div>
                    <?php endif; ?>
                    <?php if ($loginError && ! $passwordError): ?>
                        <div class="error"><?= esc($loginError) ?></div>
                    <?php endif; ?>
                </div>

                <label class="remember">
                    <input type="checkbox" name="remember"> Ingat saya
                </label>

                <button type="submit" class="btn">Masuk</button>

                <div class="supporting">Data terenkripsi dan hanya dapat diakses oleh admin terotorisasi.</div>
            </form>
        </div>
        <div class="footer-note">© <?= date('Y') ?> Dimas Cahya Ramadhan</div>
    </div>
</body>
</html>
