<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Aktivitas Harian');
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search' => '',
        'media'  => 'semua',
        'date'   => '',
        'sort'   => 'date_desc',
    ], $filters);
?>

<?php if ($message = session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <?= esc($message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="admin-card mb-4">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Aktivitas Harian</h2>
            <p class="text-muted mb-0 small">Kelola catatan aktivitas harian lengkap dengan foto atau video.</p>
        </div>
        <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/aktivitas/new') ?>">
            <span aria-hidden="true">+</span>
            <span>Tambah Aktivitas</span>
        </a>
    </div>

    <div class="admin-card__body">
        <form class="row g-3 align-items-end mb-4 js-loading-form" method="get" action="<?= base_url('admin/aktivitas') ?>">
            <div class="col-12 col-lg-4">
                <label for="filterSearchActivity" class="form-label">Pencarian</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><span aria-hidden="true">🔍</span></span>
                    <input
                        type="search"
                        name="q"
                        id="filterSearchActivity"
                        class="form-control border-start-0"
                        placeholder="Cari judul, lokasi, atau deskripsi"
                        value="<?= esc($filters['search']) ?>">
                </div>
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterMedia" class="form-label">Media</label>
                <select class="form-select" name="media" id="filterMedia">
                    <option value="semua" <?= $filters['media'] === 'semua' ? 'selected' : '' ?>>Semua</option>
                    <option value="image" <?= $filters['media'] === 'image' ? 'selected' : '' ?>>Foto</option>
                    <option value="video" <?= $filters['media'] === 'video' ? 'selected' : '' ?>>Video</option>
                    <option value="none" <?= $filters['media'] === 'none' ? 'selected' : '' ?>>Tanpa Media</option>
                </select>
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterDate" class="form-label">Tanggal</label>
                <input
                    type="date"
                    name="date"
                    id="filterDate"
                    class="form-control"
                    value="<?= esc($filters['date']) ?>">
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterSort" class="form-label">Urutkan</label>
                <select class="form-select" name="sort" id="filterSort">
                    <option value="date_desc" <?= $filters['sort'] === 'date_desc' ? 'selected' : '' ?>>Terbaru</option>
                    <option value="date_asc" <?= $filters['sort'] === 'date_asc' ? 'selected' : '' ?>>Terlama</option>
                    <option value="name_asc" <?= $filters['sort'] === 'name_asc' ? 'selected' : '' ?>>Judul A-Z</option>
                    <option value="name_desc" <?= $filters['sort'] === 'name_desc' ? 'selected' : '' ?>>Judul Z-A</option>
                </select>
            </div>
            <div class="col-6 col-lg-1">
                <button type="submit" class="btn btn-admin btn-admin-primary w-100">Terapkan</button>
            </div>
            <div class="col-6 col-lg-1">
                <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-admin btn-admin-outline w-100">Reset</a>
            </div>
        </form>


<div class="admin-loading-shell">
    <div class="admin-loading-shell__skeleton" aria-hidden="true">
        <div class="skeleton skeleton-pill mb-3" style="width: 190px;"></div>
        <?php for ($i = 0; $i < 4; $i++): ?>
            <div class="d-flex align-items-center mb-3" style="gap: 14px;">
                <div class="skeleton" style="width: 110px; height: 42px; border-radius: 12px;"></div>
                <div class="flex-fill">
                    <div class="skeleton-line skeleton-lg" style="width: 65%;"></div>
                    <div class="skeleton-line skeleton-sm" style="width: 38%;"></div>
                </div>
                <div class="d-none d-lg-block skeleton" style="width: 120px; height: 32px; border-radius: 10px;"></div>
                <div class="d-none d-lg-block skeleton" style="width: 90px; height: 32px; border-radius: 10px;"></div>
            </div>
        <?php endfor; ?>
    </div>
    <div class="admin-loading-shell__content" data-loading-links>
        <?php if (empty($activities)): ?>
            <div class="admin-empty">
                <div class="admin-empty__icon" aria-hidden="true">dY-"?,?</div>
                <div class="admin-empty__title">Belum ada aktivitas</div>
                <div class="admin-empty__text">Catat aktivitas pertama Anda untuk memulai.</div>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>Tanggal & Jam</th>
                            <th>Judul</th>
                            <th>Lokasi</th>
                            <th>Media</th>
                            <th>Diubah</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($activities as $row): ?>
                            <?php
                                $date = $row['activity_date'] ?? null;
                                $time = $row['activity_time'] ?? null;
                                $formattedDate = $date ? date('d M Y', strtotime($date)) : '-';
                                $formattedTime = $time ? date('H:i', strtotime($time)) : '-';
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?= esc($formattedDate) ?></div>
                                    <div class="text-muted small"><?= esc($formattedTime) ?></div>
                                </td>
                                <td>
                                    <div class="fw-semibold text-dark"><?= esc($row['title'] ?? '-') ?></div>
                                    <div class="text-muted small"><?= esc(mb_strimwidth((string) ($row['description'] ?? ''), 0, 60, '...')) ?></div>
                                </td>
                                <td>
                                    <?php if (! empty($row['location'])): ?>
                                        <span class="admin-badge admin-badge--secondary"><?= esc($row['location']) ?></span>
                                    <?php else: ?>
                                        <span class="text-muted small">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        $media = $row['media_type'] ?? 'none';
                                    $label = $media === 'none' ? 'Tidak ada' : ucfirst($media);
                                    $badgeClass = $media === 'video' ? 'admin-badge--primary' : 'admin-badge--secondary';
                                    ?>
                                    <span class="admin-badge <?= $badgeClass ?>"><?= esc($label) ?></span>
                                </td>
                                <td>
                                    <div class="text-muted small">
                                        <?= esc(isset($row['updated_at']) ? date('d M Y', strtotime($row['updated_at'])) : '-') ?>
                                    </div>
                                </td>
                                <td class="text-end">
                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="<?= base_url('admin/aktivitas/' . $row['id'] . '/edit') ?>" class="btn btn-sm btn-admin btn-admin-outline js-loading-link">Edit</a>
                                        <form action="<?= base_url('admin/aktivitas/' . $row['id'] . '/delete') ?>" method="post" class="d-inline" onsubmit="return confirm('Hapus aktivitas ini secara permanen?');">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="btn btn-sm btn-admin btn-admin-danger">Hapus</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-between align-items-center mt-3 flex-wrap" style="gap: .75rem;">
                <div class="text-muted small">Pagination 10 data per halaman.</div>
                <?= $pager->links('activities', 'default_full') ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
