<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $mode       = $mode ?? 'create';
    $isEdit     = $mode === 'edit';
    $this->setVar('pageTitle', $isEdit ? 'Edit Biodata' : 'Tambah Biodata');
    $profile    = $profile ?? [];
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $data       = array_merge($profile, $oldInput);
?>

<div class="admin-card">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1"><?= $isEdit ? 'Edit Biodata' : 'Tambah Biodata' ?></h2>
            <p class="text-muted mb-0 small">Lengkapi data biodata: nama, kontak, skill, dan foto.</p>
        </div>
        <a href="<?= base_url('admin/biodata') ?>" class="btn btn-admin btn-admin-outline">← Kembali</a>
    </div>
    <div class="admin-card__body">
        <form action="" method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
            <?= csrf_field() ?>

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="full_name" class="form-label">Nama Lengkap</label>
                    <input
                        type="text"
                        name="full_name"
                        id="full_name"
                        class="form-control <?= $validation && $validation->hasError('full_name') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['full_name'] ?? '') ?>"
                        required>
                    <?php if ($validation && $validation->hasError('full_name')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('full_name')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label for="headline" class="form-label">Headline / Posisi</label>
                    <input
                        type="text"
                        name="headline"
                        id="headline"
                        class="form-control <?= $validation && $validation->hasError('headline') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['headline'] ?? '') ?>"
                        required>
                    <?php if ($validation && $validation->hasError('headline')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('headline')) ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row g-3 mt-1">
                <div class="col-md-6">
                    <label for="email" class="form-label">Email</label>
                    <input
                        type="email"
                        name="email"
                        id="email"
                        class="form-control <?= $validation && $validation->hasError('email') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['email'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('email')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('email')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label for="phone" class="form-label">Telepon</label>
                    <input
                        type="text"
                        name="phone"
                        id="phone"
                        class="form-control"
                        value="<?= esc($data['phone'] ?? '') ?>">
                </div>
            </div>

            <div class="row g-3 mt-1">
                <div class="col-md-12">
                    <label for="address" class="form-label">Alamat</label>
                    <input
                        type="text"
                        name="address"
                        id="address"
                        class="form-control"
                        value="<?= esc($data['address'] ?? '') ?>">
                </div>
            </div>

            <div class="mb-3 mt-3">
                <label for="summary" class="form-label">Ringkasan</label>
                <textarea
                    name="summary"
                    id="summary"
                    rows="3"
                    class="form-control"
                    placeholder="Tuliskan ringkasan singkat"><?= esc($data['summary'] ?? '') ?></textarea>
            </div>

            <div class="mb-3">
                <label for="skills" class="form-label">Skills (pisahkan dengan koma)</label>
                <textarea
                    name="skills"
                    id="skills"
                    rows="2"
                    class="form-control <?= $validation && $validation->hasError('skills') ? 'is-invalid' : '' ?>"
                    placeholder="Contoh: PHP, CodeIgniter, MySQL"><?= esc($data['skills'] ?? '') ?></textarea>
                <?php if ($validation && $validation->hasError('skills')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('skills')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="photo" class="form-label">Foto Profil (opsional)</label>
                <input
                    type="file"
                    name="photo"
                    id="photo"
                    class="form-control <?= $validation && $validation->hasError('photo') ? 'is-invalid' : '' ?>"
                    accept=".jpg,.jpeg,.png,.webp">
                <?php if ($validation && $validation->hasError('photo')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('photo')) ?></div>
                <?php else: ?>
                    <div class="form-text text-muted">Format foto: JPG, JPEG, PNG, atau WEBP. Maks. 4 MB.</div>
                <?php endif; ?>

                <?php if ($isEdit && ! empty($profile['photo_path'])): ?>
                    <div class="mt-3 d-flex align-items-center gap-3">
                        <img src="<?= esc(base_url($profile['photo_path'])) ?>" alt="Foto profil" class="rounded" style="width: 96px; height: 96px; object-fit: cover;">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="1" id="remove_photo" name="remove_photo">
                            <label class="form-check-label" for="remove_photo">Hapus foto</label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="admin-card__footer">
                <div class="d-flex gap-2 justify-content-end">
                    <a href="<?= base_url('admin/biodata') ?>" class="btn btn-admin btn-admin-outline">Batal</a>
                    <button type="submit" class="btn btn-admin btn-admin-primary">
                        <?= $isEdit ? 'Simpan Perubahan' : 'Simpan Biodata' ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
