<?php

namespace App\Libraries;

use App\Models\NewsModel;

/**
 * Library untuk menampilkan widget-widget yang dapat digunakan di berbagai halaman.
 */
class Widget
{
    public function recentPost(array $params = [])
    {
        $limit = $params['limit'] ?? 6;
        
        $newsModel = new NewsModel();
        $recentNews = $newsModel
            ->where('status', 'published')
            ->orderBy('created_at', 'desc')
            ->limit($limit)
            ->findAll();

        return view('widget/recent_post', [
            'limit' => $limit,
            'recentNews' => $recentNews,
        ]);
    }
}