<?php

namespace App\Controllers;

use App\Models\NewsModel;
use CodeIgniter\I18n\Time;

class AdminDashboard extends BaseController
{
    public function index()
    {
        $newsModel = new NewsModel();

        helper(['text', 'url']);

        $totalNews = $newsModel->countAllResults();
        $publishedNews = $newsModel->where('status', 'published')->countAllResults();
        $draftNews = $newsModel->where('status', 'draft')->countAllResults();
        $latestNews = $newsModel->orderBy('created_at', 'desc')->limit(5)->findAll();

        $stats = [
            'totalNews'     => $totalNews,
            'publishedNews' => $publishedNews,
            'draftNews'     => $draftNews,
        ];

        return view('admin_dashboard', [
            'stats'       => $stats,
            'latestNews'  => $latestNews,
            'currentAdmin' => [
                'name'  => session()->get('admin_name'),
                'email' => session()->get('admin_email'),
            ],
            'now' => Time::now(),
        ]);
    }

    public function setting()
    {
        return view('admin_setting', [
            'currentAdmin' => [
                'name'  => session()->get('admin_name'),
                'email' => session()->get('admin_email'),
            ],
        ]);
    }
}

