<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Portfolio::index');
$routes->get('/about', 'Page::about');
$routes->get('/contact', 'Page::contact');
$routes->get('/faqs', 'Page::faqs');
$routes->get('/aktivitas', 'Activities::index');
$routes->get('/biodata', 'Biodata::index');
$routes->get('/cv', 'Biodata::show');
$routes->get('/cv/(:num)', 'Biodata::show/$1');
$routes->get('/pendidikan', 'Education::index');
$routes->get('/pegawai/(:segment)', 'Pegawai::detail/$1');
$routes->match(['GET','POST'], '/login', 'Auth::login');
$routes->get('/logout', 'Auth::logout');
$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'AdminDashboard::index');
    $routes->get('dashboard', 'AdminDashboard::index');
    $routes->get('aktivitas', 'ActivityAdmin::index');
    $routes->add('aktivitas/new', 'ActivityAdmin::create');
    $routes->add('aktivitas/(:segment)/edit', 'ActivityAdmin::edit/$1');
    $routes->post('aktivitas/(:segment)/delete', 'ActivityAdmin::delete/$1');
    $routes->get('biodata', 'BiodataAdmin::index');
    $routes->add('biodata/new', 'BiodataAdmin::create');
    $routes->add('biodata/(:segment)/edit', 'BiodataAdmin::edit/$1');
    $routes->post('biodata/(:segment)/delete', 'BiodataAdmin::delete/$1');
    $routes->get('pendidikan', 'EducationAdmin::index');
    $routes->add('pendidikan/new', 'EducationAdmin::create');
    $routes->add('pendidikan/(:segment)/edit', 'EducationAdmin::edit/$1');
    $routes->post('pendidikan/(:segment)/delete', 'EducationAdmin::delete/$1');
    $routes->get('perusahaan', 'PerusahaanAdmin::index');
    $routes->get('perusahaan/(:segment)/photo', 'PerusahaanAdmin::photo/$1');
    $routes->get('perusahaan/(:segment)/preview', 'PerusahaanAdmin::preview/$1');
    $routes->add('perusahaan/new', 'PerusahaanAdmin::create');
    $routes->add('perusahaan/(:segment)/edit', 'PerusahaanAdmin::edit/$1');
    $routes->post('perusahaan/(:segment)/delete', 'PerusahaanAdmin::delete/$1');
});
