<?= $this->extend('public/layout/template') ?>

<?= $this->section('content') ?>
<div class="container py-5">
    <div class="col-12 mb-4">
        <div class="card bg-white border-0 shadow-sm p-4 rounded-4">
            <div class="row align-items-center mb-3">
                <div class="col-md-8">
                    <h5 class="fw-bold mb-1 text-primary">Kurasi cepat</h5>
                    <p class="text-muted small mb-0">Tapis aktivitas sesuai kebutuhan Anda.</p>
                </div>
                <div class="col-md-4 text-md-end">
                    <span class="badge bg-primary bg-opacity-10 py-2 px-3 rounded-pill text-primary">
                        <i class="bi bi-compass me-1"></i> Dinamis & siap disaring
                    </span>
                </div>
            </div>

            <form action="" method="get">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label small text-muted fw-semibold">Cari</label>
                        <input type="text" name="search" class="form-control bg-light border-0 text-dark"
                            placeholder="Cari nama aktivitas" value="<?= esc($search) ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small text-muted fw-semibold">Tanggal</label>
                        <input type="date" name="date" class="form-control bg-light border-0 text-dark"
                            value="<?= esc($date ?? '') ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small text-muted fw-semibold">Jenis</label>
                        <select name="type" class="form-select bg-light border-0 text-dark">
                            <option value="all" <?= (empty($type) || $type == 'all') ? 'selected' : '' ?>>Semua</option>
                            <option value="with_media" <?= ($type == 'with_media') ? 'selected' : '' ?>>Dengan Media
                            </option>
                            <option value="no_media" <?= ($type == 'no_media') ? 'selected' : '' ?>>Tanpa Media</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small text-muted fw-semibold">Urutkan</label>
                        <select name="sort" class="form-select bg-light border-0 text-dark">
                            <option value="newest" <?= ($sort == 'newest') ? 'selected' : '' ?>>Terbaru</option>
                            <option value="oldest" <?= ($sort == 'oldest') ? 'selected' : '' ?>>Terlama</option>
                        </select>
                    </div>
                    <div class="col-12 mt-3">
                        <button type="submit" class="btn btn-primary fw-bold w-100 text-white shadow-sm">
                            Terapkan filter
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row g-3">
        <?php if ($activities): ?>
            <?php foreach ($activities as $activity): ?>
                <div class="col-md-12">
                    <div class="card border-0 shadow-sm rounded-3 overflow-hidden">
                        <div class="row g-0 align-items-center">
                            <?php if ($activity['media']): ?>
                                <div class="col-md-2">
                                    <img src="/uploads/<?= $activity['media'] ?>" class="img-fluid w-100"
                                        style="height: 100px; object-fit: cover;" alt="Aktivitas">
                                </div>
                            <?php endif; ?>

                            <div class="<?= $activity['media'] ? 'col-md-10' : 'col-md-12' ?>">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h5 class="card-title fw-bold mb-0 text-primary"><?= esc($activity['activity']) ?></h5>
                                        <small class="text-muted"><?= date('d M Y', strtotime($activity['date'])) ?></small>
                                    </div>
                                    <p class="card-text text-muted mb-0">
                                        <small>Waktu: <?= date('H:i', strtotime($activity['time'])) ?> WIB</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12 text-center py-4">
                <p class="text-muted">Tidak ada aktivitas.</p>
            </div>
        <?php endif; ?>
    </div>

    <div class="mt-4 d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
</div>
<?= $this->endSection() ?>