<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Biodata / CV</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/cv/new" class="btn btn-sm btn-outline-primary">Add New Field</a>
    </div>
</div>

<form method="get" class="mb-3">
    <div class="row g-3">
        <div class="col-md-4">
            <input type="text" name="search" class="form-control" placeholder="Search..." value="<?= esc($search) ?>">
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary" type="submit">Filter</button>
        </div>
    </div>
</form>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>Field Name</th>
                <th>Value</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($biodata): ?>
                <?php foreach ($biodata as $item): ?>
                    <tr>
                        <td><?= $item['field_key'] ?></td>
                        <td><?= $item['field_value'] ?></td>
                        <td>
                            <a href="/admin/cv/edit/<?= $item['id'] ?>" class="btn btn-sm btn-secondary">Edit</a>
                            <a href="/admin/cv/delete/<?= $item['id'] ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('Are you sure?')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="3">No fields found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?= $pager->links() ?>
</div>
<?= $this->endSection() ?>