<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?= esc($title) ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/activities" class="btn btn-sm btn-outline-secondary">Back</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <form
            action="<?= isset($activity) ? '/admin/activities/update/' . $activity['id'] : '/admin/activities/create' ?>"
            method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>

            <div class="mb-3">
                <label class="form-label">Date</label>
                <input type="date" name="date" class="form-control" value="<?= old('date', $activity['date'] ?? '') ?>"
                    required>
            </div>

            <div class="mb-3">
                <label class="form-label">Time</label>
                <input type="time" name="time" class="form-control" value="<?= old('time', $activity['time'] ?? '') ?>"
                    required>
            </div>

            <div class="mb-3">
                <label class="form-label">Activity Name</label>
                <input type="text" name="activity" class="form-control"
                    value="<?= old('activity', $activity['activity'] ?? '') ?>" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Photo/Video</label>
                <input type="file" name="media" class="form-control">
                <?php if (isset($activity['media']) && $activity['media']): ?>
                    <div class="mt-2">
                        <small>Current: <?= $activity['media'] ?></small>
                        <br>
                        <img src="/uploads/<?= $activity['media'] ?>" height="100">
                    </div>
                <?php endif; ?>
            </div>

            <button type="submit" class="btn btn-primary">Save</button>
        </form>
    </div>
</div>
<?= $this->endSection() ?>