<?php

namespace App\Controllers;

use App\Models\ActivityModel;
use App\Models\BiodataModel;
use App\Models\EducationModel;

class Home extends BaseController
{
    public function index()
    {
        return view('public/home');
    }

    public function activities()
    {
        $model = new ActivityModel();

        $search = $this->request->getGet('search');
        $date = $this->request->getGet('date');
        $type = $this->request->getGet('type'); // all, with_media, no_media
        $sort = $this->request->getGet('sort') ?? 'newest'; // newest, oldest

        $activities = $model;

        // Search
        if ($search) {
            $activities = $activities->like('activity', $search);
        }

        // Filter by Date
        if ($date) {
            $activities = $activities->where('date', $date);
        }

        // Filter by Type (Media presence)
        if ($type === 'with_media') {
            $activities = $activities->where('media !=', null)->where('media !=', '');
        } elseif ($type === 'no_media') {
            $activities = $activities->groupStart()->where('media', null)->orWhere('media', '')->groupEnd();
        }

        // Sorting
        if ($sort === 'oldest') {
            $activities = $activities->orderBy('date', 'ASC')->orderBy('time', 'ASC');
        } else {
            // Default newest
            $activities = $activities->orderBy('date', 'DESC')->orderBy('time', 'DESC');
        }

        $data = [
            'activities' => $activities->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'date' => $date,
            'type' => $type,
            'sort' => $sort,
            'title' => 'Daily Activities'
        ];

        return view('public/activities', $data);
    }

    public function cv()
    {
        $model = new BiodataModel();

        $data = [
            'biodata' => $model->findAll(),
            'title' => 'Curriculum Vitae'
        ];

        return view('public/cv', $data);
    }

    public function education()
    {
        $model = new EducationModel();

        $search = $this->request->getGet('search');
        $start_year = $this->request->getGet('start_year');
        $sort = $this->request->getGet('sort') ?? 'newest';

        $education = $model;

        if ($search) {
            $education = $education->like('institution', $search)->orLike('description', $search);
        }

        if ($start_year) {
            $education = $education->where('start_year', $start_year);
        }

        if ($sort === 'oldest') {
            $education = $education->orderBy('start_year', 'ASC');
        } else {
            $education = $education->orderBy('start_year', 'DESC');
        }

        $data = [
            'education' => $education->paginate(10), // Ordered by recent
            'pager' => $model->pager,
            'search' => $search,
            'start_year' => $start_year,
            'sort' => $sort,
            'title' => 'Education History'
        ];

        return view('public/education', $data);
    }
}
