<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?> - CI4 Creative</title>
    <link href="<?= base_url('css/style.css') ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .sidebar-menu-item {
            position: relative;
            overflow: hidden;
        }
        .sidebar-menu-item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            width: 3px;
            height: 100%;
            background: linear-gradient(to bottom, #4F46E5, #EC4899);
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }
        .sidebar-menu-item:hover::before,
        .sidebar-menu-item.active::before {
            transform: scaleY(1);
        }
    </style>
</head>
<body class="bg-gradient-to-br from-gray-100 to-gray-200 font-sans antialiased" 
      x-data="{ 
          sidebarOpen: window.innerWidth >= 768, 
          toggleSidebar() { this.sidebarOpen = !this.sidebarOpen },
          handleResize() {
              if (window.innerWidth >= 768) { this.sidebarOpen = true; } 
              else { this.sidebarOpen = false; }
          }
      }"
      @resize.window="handleResize()">

    <div class="flex h-screen overflow-hidden relative">
        <!-- Sidebar -->
        <aside class="absolute md:relative z-50 h-full flex-shrink-0 transition-all duration-500 transform" 
               :class="sidebarOpen ? 'translate-x-0 w-72' : '-translate-x-full md:translate-x-0 md:w-72'"
               @click.away="if(window.innerWidth < 768 && sidebarOpen) sidebarOpen = false">
            
            <div class="h-full bg-gradient-to-b from-gray-900 via-gray-900 to-gray-950 text-white shadow-2xl flex flex-col">
                <!-- Logo -->
                <div class="h-20 flex items-center justify-center border-b border-gray-800/50">
                    <h1 class="text-2xl font-bold">
                        <span class="bg-clip-text text-transparent bg-gradient-to-r from-primary via-purple-500 to-secondary">Admin</span>
                        <span class="text-white">Panel</span>
                    </h1>
                </div>
                
                <!-- Navigation -->
                <nav class="flex-1 py-6 px-4 space-y-2 overflow-y-auto">
                    <a href="<?= base_url('admin/dashboard') ?>" 
                       class="sidebar-menu-item flex items-center py-3.5 px-4 rounded-xl transition-all duration-300 <?= uri_string() == 'admin/dashboard' ? 'active bg-gradient-to-r from-primary/20 to-transparent text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white' ?>">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-indigo-500 to-indigo-600 flex items-center justify-center mr-3 shadow-lg shadow-indigo-500/30">
                            <i class="fas fa-th-large"></i>
                        </div>
                        <span class="font-medium">Dashboard</span>
                    </a>
                    <a href="<?= base_url('admin/profile') ?>" 
                       class="sidebar-menu-item flex items-center py-3.5 px-4 rounded-xl transition-all duration-300 <?= strpos(uri_string(), 'admin/profile') !== false ? 'active bg-gradient-to-r from-primary/20 to-transparent text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white' ?>">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-blue-500 to-cyan-500 flex items-center justify-center mr-3 shadow-lg shadow-blue-500/30">
                            <i class="fas fa-user"></i>
                        </div>
                        <span class="font-medium">Profil (CV)</span>
                    </a>
                    <a href="<?= base_url('admin/education') ?>" 
                       class="sidebar-menu-item flex items-center py-3.5 px-4 rounded-xl transition-all duration-300 <?= strpos(uri_string(), 'admin/education') !== false ? 'active bg-gradient-to-r from-primary/20 to-transparent text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white' ?>">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-green-500 to-emerald-500 flex items-center justify-center mr-3 shadow-lg shadow-green-500/30">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <span class="font-medium">Pendidikan</span>
                    </a>
                    <a href="<?= base_url('admin/activity') ?>" 
                       class="sidebar-menu-item flex items-center py-3.5 px-4 rounded-xl transition-all duration-300 <?= strpos(uri_string(), 'admin/activity') !== false ? 'active bg-gradient-to-r from-primary/20 to-transparent text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white' ?>">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-orange-500 to-red-500 flex items-center justify-center mr-3 shadow-lg shadow-orange-500/30">
                            <i class="fas fa-camera"></i>
                        </div>
                        <span class="font-medium">Aktivitas</span>
                    </a>
                    <a href="<?= base_url('admin/certificate') ?>" 
                       class="sidebar-menu-item flex items-center py-3.5 px-4 rounded-xl transition-all duration-300 <?= strpos(uri_string(), 'admin/certificate') !== false ? 'active bg-gradient-to-r from-primary/20 to-transparent text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white' ?>">
                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-purple-500 to-pink-500 flex items-center justify-center mr-3 shadow-lg shadow-purple-500/30">
                            <i class="fas fa-certificate"></i>
                        </div>
                        <span class="font-medium">Sertifikat</span>
                    </a>
                </nav>
                
                <!-- Logout Button -->
                <div class="p-4 border-t border-gray-800/50">
                    <a href="<?= base_url('logout') ?>" 
                       class="flex items-center py-3 px-4 rounded-xl bg-red-500/10 text-red-400 hover:bg-red-500 hover:text-white transition-all duration-300">
                        <i class="fas fa-sign-out-alt mr-3"></i>
                        <span class="font-medium">Keluar</span>
                    </a>
                </div>
            </div>
        </aside>

        <!-- Overlay for Mobile -->
        <div x-show="sidebarOpen && window.innerWidth < 768" 
             class="fixed inset-0 bg-black/60 backdrop-blur-sm z-40 md:hidden" 
             @click="sidebarOpen = false" 
             x-transition.opacity></div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden w-full relative z-0">
            <!-- Header -->
            <header class="h-20 bg-white/80 backdrop-blur-xl shadow-sm border-b border-gray-200/50 flex items-center justify-between px-6 relative z-50">
                <div class="flex items-center">
                    <button @click.stop="toggleSidebar()" class="md:hidden p-3 rounded-xl hover:bg-gray-100 transition-colors mr-4">
                        <i class="fas fa-bars text-xl text-gray-600"></i>
                    </button>
                    <div>
                        <h2 class="text-lg font-bold text-gray-800"><?= $title ?? 'Dashboard' ?></h2>
                        <p class="text-sm text-gray-500">Selamat datang kembali, Admin</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="hidden sm:flex items-center px-4 py-2 bg-gray-100 rounded-xl">
                        <i class="fas fa-calendar text-gray-400 mr-2"></i>
                        <span class="text-sm text-gray-600"><?= date('d M Y') ?></span>
                    </div>
                    <a href="<?= base_url('/') ?>" target="_blank" class="p-3 bg-primary/10 text-primary rounded-xl hover:bg-primary hover:text-white transition-all duration-300" title="Lihat Website">
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            </header>

            <!-- Main Scrollable -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gradient-to-br from-gray-50 to-gray-100 p-6">
                <?= $this->renderSection('content') ?>
            </main>
        </div>
    </div>

    <script>
        // Check for Flash Data Messages
        <?php if(session()->getFlashdata('message')): ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: '<?= session()->getFlashdata('message') ?>',
                timer: 3000,
                showConfirmButton: false,
                customClass: {
                    popup: 'rounded-2xl'
                }
            });
        <?php endif; ?>

        <?php if(session()->getFlashdata('error')): ?>
            Swal.fire({
                icon: 'error',
                title: 'Gagal!',
                text: '<?= session()->getFlashdata('error') ?>',
                confirmButtonColor: '#EF4444',
                customClass: {
                    popup: 'rounded-2xl'
                }
            });
        <?php endif; ?>

        <?php if(session()->getFlashdata('warning')): ?>
            Swal.fire({
                icon: 'warning',
                title: 'Peringatan!',
                text: '<?= session()->getFlashdata('warning') ?>',
                confirmButtonColor: '#F59E0B',
                customClass: {
                    popup: 'rounded-2xl'
                }
            });
        <?php endif; ?>
    </script>
    <script>
        // Confirm Delete
        function confirmDelete(id, url) {
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#EF4444',
                cancelButtonColor: '#6B7280',
                confirmButtonText: 'Ya, Hapus!',
                cancelButtonText: 'Batal',
                customClass: {
                    popup: 'rounded-2xl',
                    confirmButton: 'rounded-xl',
                    cancelButton: 'rounded-xl'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            })
        }
    </script>

</body>
</html>
