<?= $this->extend('layouts/frontend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-12">
    
    <!-- Header -->
    <div class="flex justify-between items-end mb-12 page-transition">
        <div>
            <h2 class="text-4xl font-bold mb-2">Perjalanan Pendidikan</h2>
            <p class="text-gray-400">Jalur akademik dan kualifikasi saya.</p>
        </div>
        <form action="" method="get" class="w-full md:w-auto flex flex-col md:flex-row gap-3">
            <!-- Filter -->
            <select name="filter" onchange="this.form.submit()" class="bg-gray-800 border border-gray-700 text-white px-4 py-2 rounded-lg focus:outline-none focus:border-primary">
                <option value="">Semua Jenjang</option>
                <option value="SD" <?= $filter == 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="SMP" <?= $filter == 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SMA/SMK" <?= $filter == 'SMA/SMK' ? 'selected' : '' ?>>SMA/SMK</option>
                <option value="Diploma" <?= $filter == 'Diploma' ? 'selected' : '' ?>>Diploma</option>
                <option value="Sarjana (S1)" <?= $filter == 'Sarjana (S1)' ? 'selected' : '' ?>>Sarjana (S1)</option>
                <option value="Magister (S2)" <?= $filter == 'Magister (S2)' ? 'selected' : '' ?>>Magister (S2)</option>
                <option value="Doktor (S3)" <?= $filter == 'Doktor (S3)' ? 'selected' : '' ?>>Doktor (S3)</option>
            </select>

            <!-- Sort -->
            <select name="order" onchange="this.form.submit()" class="bg-gray-800 border border-gray-700 text-white px-4 py-2 rounded-lg focus:outline-none focus:border-primary">
                <option value="DESC" <?= $order == 'DESC' ? 'selected' : '' ?>>Terbaru</option>
                <option value="ASC" <?= $order == 'ASC' ? 'selected' : '' ?>>Terlama</option>
            </select>

            <!-- Search -->
            <div class="relative">
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari Pendidikan..." class="bg-gray-800 border border-gray-700 text-white pl-4 pr-10 py-2 rounded-lg focus:outline-none focus:border-primary w-full md:w-64">
                <button type="submit" class="absolute right-3 top-2 text-gray-400 hover:text-white">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>

    <!-- Timeline -->
    <div class="relative wrap overflow-hidden p-4 h-full">
        <div class="border-2-2 absolute border-opacity-20 border-gray-700 h-full border" style="left: 50%"></div>
        
        <?php foreach($educations as $index => $edu): ?>
            <div class="mb-8 flex justify-between items-center w-full right-timeline page-transition" style="animation-delay: <?= $index * 150 ?>ms;">
                <div class="order-1 w-5/12"></div>
                <div class="z-20 flex items-center order-1 bg-gray-800 shadow-xl w-8 h-8 rounded-full border-4 border-gray-900 ring-4 <?= $index % 2 == 0 ? 'ring-primary' : 'ring-secondary' ?>">
                   <!-- Dot -->
                </div>
                <div class="order-1 bg-gray-800 rounded-lg shadow-xl w-5/12 px-6 py-4 transform hover:scale-105 transition duration-300 border border-t-4 <?= $index % 2 == 0 ? 'border-primary' : 'border-secondary' ?>">
                    <h3 class="font-bold text-white text-xl mb-1"><?= esc($edu['institution']) ?></h3>
                    <p class="text-sm text-gray-400 font-bold mb-2">
                        <?= esc($edu['start_year']) ?> - <?= $edu['end_year'] ? esc($edu['end_year']) : 'Sekarang' ?>
                    </p>
                    <div class="text-xs inline-block py-1 px-2 uppercase rounded text-white bg-opacity-50 font-bold mb-2 <?= $index % 2 == 0 ? 'bg-primary' : 'bg-secondary' ?>">
                        <?= esc($edu['level']) ?>
                    </div>
                    <?php if($edu['major']): ?>
                        <p class="text-gray-300 italic mb-2"><?= esc($edu['major']) ?></p>
                    <?php endif; ?>
                    <p class="text-gray-400 text-sm leading-snug">
                       <?= esc($edu['description']) ?>
                    </p>
                </div>
            </div>
        <?php endforeach; ?>

        <?php if(empty($educations)): ?>
            <p class="text-center text-gray-500 py-12">Riwayat pendidikan tidak ditemukan.</p>
        <?php endif; ?>
    </div>

    <div class="mt-8 page-transition">
        <?= $pager->links() ?>
    </div>
</div>

<style>
    /* Mobile Timeline Fix */
    @media (max-width: 768px) {
        .right-timeline .w-5\/12 { width: 100%; margin-left: 20px; }
        .right-timeline .order-1:first-child { display: none; }
        .border-2-2 { left: 10px !important; }
        .z-20 { left: 0 !important; }
    }
</style>

<?= $this->endSection() ?>
