<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Creative App</title>
    <link href="<?= base_url('css/style.css') ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
    <style>
        @keyframes blob {
            0% { transform: translate(0px, 0px) scale(1); }
            33% { transform: translate(30px, -50px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
            100% { transform: translate(0px, 0px) scale(1); }
        }
        .animate-blob {
            animation: blob 7s infinite;
        }
        .animation-delay-2000 {
            animation-delay: 2s;
        }
        .animation-delay-4000 {
            animation-delay: 4s;
        }
        
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-15px); }
            100% { transform: translateY(0px); }
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        /* Automatic Moving Animations */
        @keyframes drift-left {
            0% { transform: translateX(0) translateY(0) rotate(0deg); opacity: 0.2; }
            50% { transform: translateX(-50px) translateY(-20px) rotate(180deg); opacity: 0.5; }
            100% { transform: translateX(0) translateY(0) rotate(360deg); opacity: 0.2; }
        }
        @keyframes drift-right {
            0% { transform: translateX(0) translateY(0) rotate(0deg); opacity: 0.2; }
            50% { transform: translateX(50px) translateY(20px) rotate(-180deg); opacity: 0.5; }
            100% { transform: translateX(0) translateY(0) rotate(-360deg); opacity: 0.2; }
        }
        
        .animate-drift-left { animation: drift-left 15s infinite linear; }
        .animate-drift-right { animation: drift-right 18s infinite linear; }
        
        /* FIX: Paused animation state for when user is typing */
        .paused {
            animation-play-state: paused !important;
        }
        
        /* Enhanced Input Focus Glow */
        .input-glow:focus {
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.3), 0 0 20px rgba(79, 70, 229, 0.2);
        }
        
        /* Premium Button Shine Effect */
        @keyframes shine {
            0% { left: -100%; }
            100% { left: 100%; }
        }
        .btn-shine::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        .btn-shine:hover::before {
            animation: shine 0.7s ease-in-out;
        }
    </style>
</head>
<body class="bg-gray-900 font-sans antialiased text-white overflow-hidden relative min-h-screen flex items-center justify-center" id="main-body">

    <!-- Interactive Parallax Background Elements -->
    <div class="absolute inset-0 overflow-hidden z-0 pointer-events-none" id="scene">
        <!-- Blobs (Existing) -->
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary opacity-20 rounded-full mix-blend-screen filter blur-3xl animate-blob" data-depth="0.2"></div>
        <div class="absolute top-0 right-0 w-96 h-96 bg-secondary opacity-20 rounded-full mix-blend-screen filter blur-3xl animate-blob animation-delay-2000" data-depth="0.3"></div>
        <div class="absolute -bottom-32 left-20 w-96 h-96 bg-pink-600 opacity-20 rounded-full mix-blend-screen filter blur-3xl animate-blob animation-delay-4000" data-depth="0.5"></div>

        <!-- Auto-Moving Decorative Elements (Left) -->
        <div class="absolute top-20 left-10 text-cyan-500 opacity-20 animate-drift-left text-6xl hidden sm:block"><i class="fas fa-atom"></i></div>
        <div class="absolute bottom-40 left-20 text-purple-500 opacity-20 animate-drift-left animation-delay-2000 text-4xl hidden sm:block"><i class="fas fa-cube"></i></div>
        <div class="absolute top-1/2 left-5 w-24 h-24 border-2 border-dashed border-gray-600 rounded-full opacity-10 animate-spin-slow duration-[20s] hidden md:block"></div>

        <!-- Auto-Moving Decorative Elements (Right) -->
        <div class="absolute top-40 right-10 text-pink-500 opacity-20 animate-drift-right text-5xl hidden sm:block"><i class="fas fa-rocket"></i></div>
        <div class="absolute bottom-20 right-20 text-yellow-500 opacity-20 animate-drift-right animation-delay-4000 text-4xl hidden sm:block"><i class="fas fa-asterisk"></i></div>
        <div class="absolute bottom-1/3 right-5 w-32 h-32 border border-gray-600 rotate-45 opacity-10 animate-pulse hidden md:block"></div>

        <!-- Floating Tech Icons (Left Side) -->
        <div class="absolute top-1/4 left-10 md:left-24 text-gray-700 opacity-50 hover:text-primary hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden sm:block" data-depth="0.6">
            <i class="fas fa-code text-6xl"></i>
        </div>
        <div class="absolute bottom-1/3 left-16 md:left-40 text-gray-800 opacity-40 hover:text-secondary hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden sm:block" data-depth="0.8">
            <i class="fas fa-database text-4xl"></i>
        </div>
        <div class="absolute top-20 left-1/4 text-gray-800 opacity-30 hover:text-pink-500 hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden md:block" data-depth="0.4">
            <i class="fas fa-terminal text-3xl"></i>
        </div>

        <!-- Floating Creative Icons (Right Side) -->
        <div class="absolute top-1/3 right-10 md:right-24 text-gray-700 opacity-50 hover:text-green-400 hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden sm:block" data-depth="0.6">
            <i class="fas fa-palette text-6xl"></i>
        </div>
        <div class="absolute bottom-1/4 right-16 md:right-40 text-gray-800 opacity-40 hover:text-yellow-400 hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden sm:block" data-depth="0.8">
            <i class="fas fa-camera text-5xl"></i>
        </div>
        <div class="absolute top-20 right-1/4 text-gray-800 opacity-30 hover:text-blue-400 hover:opacity-100 transition-all duration-300 transform hover:scale-125 cursor-pointer pointer-events-auto interactive-icon hidden md:block" data-depth="0.4">
            <i class="fas fa-layer-group text-3xl"></i>
        </div>
        
        <!-- Additional Shapes & Particles -->
        <div class="absolute top-1/2 left-20 w-3 h-3 bg-blue-400 rounded-full opacity-60 animate-pulse pointer-events-auto interactive-shape hidden sm:block" data-depth="0.9"></div>
        <div class="absolute bottom-20 right-20 w-4 h-4 border-2 border-pink-500 transform rotate-45 opacity-60 pointer-events-auto interactive-shape hidden sm:block" data-depth="0.7"></div>
        <div class="absolute top-10 left-1/2 w-2 h-2 bg-white rounded-full opacity-40" data-depth="0.1"></div>
        <div class="absolute bottom-10 right-1/3 text-2xl text-purple-500 opacity-30 pointer-events-auto interactive-icon hidden sm:block" data-depth="0.5"><i class="fas fa-plus"></i></div>
        <div class="absolute bottom-1/2 right-10 text-xl text-green-500 opacity-20 pointer-events-auto interactive-icon hidden sm:block" data-depth="0.3"><i class="fas fa-square transform rotate-12"></i></div>
    </div>

    <!-- Login Card with Float Animation -->
    <div class="relative z-10 w-full max-w-md px-4 sm:px-6 animate-float" id="loginCardContainer">
        <div class="bg-gray-800/70 backdrop-blur-xl rounded-2xl shadow-2xl border border-gray-700/50 p-6 sm:p-8 transform hover:scale-[1.01] transition-all duration-300">
            
            <div class="text-center mb-8">
                <div class="inline-block p-4 rounded-full bg-gradient-to-br from-primary/20 to-purple-600/20 mb-4 shadow-lg shadow-primary/20 group cursor-pointer transition-all duration-300 hover:shadow-primary/40" onclick="anime({targets: this, rotate: '1turn', duration: 1000})">
                    <i class="fas fa-lock text-3xl text-primary group-hover:text-white transition-colors"></i>
                </div>
                <h2 class="text-2xl sm:text-3xl font-bold tracking-tight text-white">Selamat Datang</h2>
                <p class="text-gray-400 mt-2 text-sm">Masuk untuk mengakses dashboard Anda</p>
            </div>

            <?php if(session()->getFlashdata('error')):?>
                <div class="bg-red-500/20 border border-red-500/50 text-red-200 px-4 py-3 rounded-xl relative mb-6 text-sm flex items-center gap-3 animate-pulse">
                    <i class="fas fa-exclamation-circle"></i>
                    <span><?= session()->getFlashdata('error') ?></span>
                </div>
            <?php endif;?>

            <form action="<?= base_url('/auth/login') ?>" method="post" class="space-y-5">
                <?= csrf_field() ?>
                
                <div class="space-y-2">
                    <label for="email" class="text-sm font-medium text-gray-300 block ml-1">Alamat Email</label>
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fas fa-envelope text-gray-500 group-focus-within:text-primary transition-colors duration-300"></i>
                        </div>
                        <input type="email" name="email" id="email" class="input-glow w-full pl-11 pr-4 py-3.5 bg-gray-900/60 border border-gray-600/50 rounded-xl text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all duration-300" placeholder="admin@example.com" required>
                    </div>
                </div>

                <div class="space-y-2">
                    <label for="password" class="text-sm font-medium text-gray-300 block ml-1">Kata Sandi</label>
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fas fa-key text-gray-500 group-focus-within:text-primary transition-colors duration-300"></i>
                        </div>
                        <input type="password" name="password" id="password" class="input-glow w-full pl-11 pr-12 py-3.5 bg-gray-900/60 border border-gray-600/50 rounded-xl text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all duration-300" placeholder="••••••••" required>
                        
                        <!-- Eye Icon -->
                        <button type="button" id="togglePassword" class="absolute inset-y-0 right-0 pr-4 flex items-center text-gray-400 hover:text-white focus:outline-none transition-all duration-300 hover:scale-110">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>

                <button type="submit" class="btn-shine w-full py-4 px-4 bg-gradient-to-r from-primary to-indigo-600 hover:from-indigo-600 hover:to-primary text-white font-bold rounded-xl shadow-lg shadow-primary/30 transform hover:-translate-y-1 hover:shadow-primary/50 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary focus:ring-offset-gray-900 relative overflow-hidden">
                    <span class="relative z-10 flex items-center justify-center gap-2">
                        <i class="fas fa-sign-in-alt"></i>
                        Masuk
                    </span>
                </button>
            </form>

            <div class="mt-8 text-center text-xs text-gray-500 relative">
                <span class="hover:text-primary cursor-pointer transition-colors duration-300" onclick="anime({targets: this, translateY: [-5, 0], scale: [1.1, 1], duration: 500})">&copy; <?= date('Y') ?> Creative App. Hak cipta dilindungi.</span>
            </div>
        </div>
    </div>

    <!-- Click Burst Effect Container -->
    <div id="click-effect-container" class="fixed inset-0 pointer-events-none z-50"></div>

    <script>
        // Toggle Password Visibility
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#password');
        const icon = togglePassword.querySelector('i');

        togglePassword.addEventListener('click', function (e) {
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            
            icon.classList.remove('fa-eye', 'fa-eye-slash');
            icon.classList.add(type === 'text' ? 'fa-eye-slash' : 'fa-eye');
            
            // Icon Animation
            anime({
                targets: icon,
                scale: [0.8, 1.2, 1],
                duration: 400
            });
        });

        // Pause Float Animation on Input Focus
        const loginCardContainer = document.getElementById('loginCardContainer');
        const inputs = loginCardContainer.querySelectorAll('input');

        inputs.forEach(input => {
            input.addEventListener('focus', () => {
                loginCardContainer.classList.add('paused');
            });
            input.addEventListener('blur', () => {
                loginCardContainer.classList.remove('paused');
            });
        });

        // Parallax Effect
        document.addEventListener('mousemove', (e) => {
            const layers = document.querySelectorAll('.animate-blob, .interactive-icon, .interactive-shape');
            const x = (window.innerWidth - e.pageX * 2) / 100;
            const y = (window.innerHeight - e.pageY * 2) / 100;

            layers.forEach(layer => {
                const depth = layer.getAttribute('data-depth') || 0.1;
                const moveX = x * depth * 20;
                const moveY = y * depth * 20;
                
                layer.style.transform = `translateX(${moveX}px) translateY(${moveY}px)`;
            });
        });

        // Click Burst Animation
        document.addEventListener('click', (e) => {
            const container = document.getElementById('click-effect-container');
            const pointer = document.createElement('div');
            pointer.classList.add('cursor-pointer-effect');
            pointer.style.left = e.clientX + 'px';
            pointer.style.top = e.clientY + 'px';
            container.appendChild(pointer);

            anime({
                targets: pointer,
                scale: [0, 2],
                opacity: [0.8, 0],
                duration: 600,
                easing: 'easeOutExpo',
                complete: () => pointer.remove()
            });

            // If clicked on interactive icon, do specific animation
            if(e.target.closest('.interactive-icon')) {
                const icon = e.target.closest('.interactive-icon');
                anime({
                    targets: icon,
                    rotate: '1turn',
                    scale: [1.5, 1],
                    duration: 800
                });
            }
        });

        // Show Error Alert for Login Failures
        <?php if(session()->getFlashdata('msg')): ?>
        Swal.fire({
            icon: 'error',
            title: 'Login Gagal!',
            text: '<?= session()->getFlashdata('msg') ?>',
            confirmButtonColor: '#6366f1',
            background: '#1f2937',
            color: '#fff'
        });
        <?php endif; ?>
    </script>
</body>
</html>
