<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold">Daftar Profil</h3>
    </div>

    <!-- Filter & Search -->
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-center bg-white p-4 rounded-xl shadow-sm border border-gray-100">
        <form action="" method="get" class="flex w-full sm:w-auto items-center gap-2">
            <!-- Filter Dropdown -->
            <select name="filter" onchange="this.form.submit()" class="border border-gray-200 rounded-lg py-2 px-4 focus:outline-none focus:ring-2 focus:ring-primary text-gray-600">
                <option value="">Semua Profil</option>
                <option value="has_photo" <?= ($filter ?? '') == 'has_photo' ? 'selected' : '' ?>>Ada Foto</option>
                <option value="no_photo" <?= ($filter ?? '') == 'no_photo' ? 'selected' : '' ?>>Tanpa Foto</option>
            </select>

            <div class="relative flex-grow">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400"></i>
                </div>
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari profil..." class="pl-10 pr-4 py-2 border border-gray-200 rounded-lg w-full sm:w-64 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
            </div>
            <button type="submit" class="bg-gray-100 text-gray-600 px-4 py-2 rounded-lg hover:bg-gray-200 transition-colors font-medium">Cari</button>
        </form>
    </div>

    <?php if(session()->getFlashdata('message')): ?>
        <div class="bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-r shadow-sm mb-6 flex items-center" role="alert">
            <i class="fas fa-check-circle mr-3 text-lg"></i>
            <span class="font-medium"><?= session()->getFlashdata('message') ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-lg rounded-2xl overflow-hidden border border-gray-100">
        <table class="min-w-full leading-normal">
            <thead>
                <tr>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        Foto
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/profile') ?>?sort=full_name&order=<?= ($order ?? 'DESC') == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search ?? '') ?>&filter=<?= esc($filter ?? '') ?>" class="flex items-center hover:text-primary">
                            Nama Lengkap
                            <?php if(($sort ?? '') == 'full_name'): ?>
                                <i class="fas fa-sort-<?= ($order ?? 'DESC') == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/profile') ?>?sort=email&order=<?= ($order ?? 'DESC') == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search ?? '') ?>&filter=<?= esc($filter ?? '') ?>" class="flex items-center hover:text-primary">
                            Email
                            <?php if(($sort ?? '') == 'email'): ?>
                                <i class="fas fa-sort-<?= ($order ?? 'DESC') == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider text-right">
                        Aksi
                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php foreach ($profiles as $profile): ?>
                <tr class="hover:bg-gray-50 transition-colors duration-150">
                    <td class="px-6 py-4">
                        <?php if($profile['photo']): ?>
                            <img src="<?= base_url($profile['photo']) ?>" alt="" class="h-12 w-12 rounded-full object-cover border-2 border-white shadow-sm">
                        <?php else: ?>
                            <div class="h-12 w-12 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-500 font-bold text-xl shadow-sm">
                                <?= substr(esc($profile['full_name']), 0, 1) ?>
                            </div>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4">
                        <p class="text-gray-900 font-bold"><?= esc($profile['full_name']) ?></p>
                    </td>
                    <td class="px-6 py-4">
                        <p class="text-gray-500 text-sm"><?= esc($profile['email']) ?></p>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex items-center justify-end space-x-3">
                            <a href="<?= base_url('admin/profile/' . $profile['id'] . '/edit') ?>" class="text-yellow-500 hover:text-yellow-600 bg-yellow-50 hover:bg-yellow-100 p-2 rounded-lg transition-all" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <button onclick="confirmDelete(<?= $profile['id'] ?>, '<?= base_url('admin/profile/' . $profile['id'] . '/delete') ?>')" class="text-red-500 hover:text-red-600 bg-red-50 hover:bg-red-100 p-2 rounded-lg transition-all" title="Hapus">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex flex-col xs:flex-row items-center xs:justify-between">
             <?= $pager->links() ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
