<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold"><?= $title ?></h3>
        <a href="<?= base_url('admin/profile') ?>" class="flex items-center text-gray-600 hover:text-indigo-600 transition-colors">
            <i class="fas fa-arrow-left mr-2"></i> Kembali
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
        <?php if(session()->getFlashdata('errors')): ?>
            <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r">
                <div class="font-bold mb-2"><i class="fas fa-exclamation-circle mr-2"></i> Ada Kesalahan:</div>
                <ul class="list-disc list-inside text-sm">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?= isset($profile) ? base_url('admin/profile/' . $profile['id'] . '/update') : base_url('admin/profile/create') ?>" method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Full Name -->
                <div class="mb-4">
                    <label for="full_name" class="block text-gray-700 font-bold mb-2">Nama Lengkap</label>
                    <input type="text" name="full_name" id="full_name" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($profile) ? esc($profile['full_name']) : old('full_name') ?>" required placeholder="Masukkan nama lengkap">
                </div>

                <!-- Email -->
                <div class="mb-4">
                    <label for="email" class="block text-gray-700 font-bold mb-2">Email</label>
                    <input type="email" name="email" id="email" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($profile) ? esc($profile['email']) : old('email') ?>" required placeholder="contoh@email.com">
                </div>

                <!-- Phone -->
                <div class="mb-4">
                    <label for="phone" class="block text-gray-700 font-bold mb-2">No. Telepon</label>
                    <input type="text" name="phone" id="phone" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($profile) ? esc($profile['phone']) : old('phone') ?>" placeholder="0812...">
                </div>

                 <!-- Address -->
                 <div class="mb-4">
                    <label for="address" class="block text-gray-700 font-bold mb-2">Alamat</label>
                    <textarea name="address" id="address" rows="3" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" placeholder="Alamat lengkap..."><?= isset($profile) ? esc($profile['address']) : old('address') ?></textarea>
                </div>

                <!-- Bio -->
                <div class="mb-4 md:col-span-2">
                    <label for="bio" class="block text-gray-700 font-bold mb-2">Biografi Singkat</label>
                    <textarea name="bio" id="bio" rows="4" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" placeholder="Ceritakan sedikit tentang anda..."><?= isset($profile) ? esc($profile['bio']) : old('bio') ?></textarea>
                </div>

                <!-- Photo -->
                <div class="mb-6 md:col-span-2">
                    <label for="photo" class="block text-gray-700 font-bold mb-2">Foto Profil</label>
                    <div class="flex items-center space-x-4">
                        <?php if(isset($profile) && $profile['photo']): ?>
                            <img src="<?= base_url($profile['photo']) ?>" class="h-24 w-24 object-cover rounded-xl border-2 border-gray-200 shadow-sm">
                        <?php endif; ?>
                        <div class="w-full">
                            <input type="file" name="photo" id="photo" class="block w-full text-sm text-gray-500
                                file:mr-4 file:py-2 file:px-4
                                file:rounded-full file:border-0
                                file:text-sm file:font-semibold
                                file:bg-primary file:text-white
                                hover:file:bg-indigo-700
                                cursor-pointer
                            ">
                            <p class="text-xs text-gray-500 mt-1">Format: JPG, PNG, GIF. Maks: 2MB</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="bg-primary hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                    <i class="fas fa-save mr-2"></i> Simpan Profil
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
