<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold">Riwayat Pendidikan</h3>
        <a href="<?= base_url('admin/education/new') ?>" class="bg-primary hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
            <i class="fas fa-plus mr-2"></i> Tambah Data
        </a>
    </div>

    <!-- Filter & Search -->
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-center bg-white p-4 rounded-xl shadow-sm border border-gray-100">
        <form action="" method="get" class="flex w-full sm:w-auto relative group items-center gap-2">
            <!-- Filter Dropdown -->
            <select name="filter" onchange="this.form.submit()" class="border border-gray-200 rounded-lg py-2 px-4 focus:outline-none focus:ring-2 focus:ring-primary text-gray-600">
                <option value="">Semua Jenjang</option>
                <option value="SD" <?= $filter == 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="SMP" <?= $filter == 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SMA/SMK" <?= $filter == 'SMA/SMK' ? 'selected' : '' ?>>SMA/SMK</option>
                <option value="Diploma" <?= $filter == 'Diploma' ? 'selected' : '' ?>>Diploma</option>
                <option value="Sarjana (S1)" <?= $filter == 'Sarjana (S1)' ? 'selected' : '' ?>>Sarjana (S1)</option>
                <option value="Magister (S2)" <?= $filter == 'Magister (S2)' ? 'selected' : '' ?>>Magister (S2)</option>
                <option value="Doktor (S3)" <?= $filter == 'Doktor (S3)' ? 'selected' : '' ?>>Doktor (S3)</option>
            </select>

            <div class="relative flex-grow">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400 group-focus-within:text-primary transition-colors"></i>
                </div>
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari pendidikan..." class="pl-10 pr-4 py-2 border border-gray-200 rounded-lg w-full sm:w-64 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
            </div>
            <button type="submit" class="bg-gray-100 text-gray-600 px-4 py-2 rounded-lg hover:bg-gray-200 transition-colors font-medium">Cari</button>
        </form>
    </div>

    <?php if(session()->getFlashdata('message')): ?>
        <div class="bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-r shadow-sm mb-6 flex items-center" role="alert">
            <i class="fas fa-check-circle mr-3 text-lg"></i>
            <span class="font-medium"><?= session()->getFlashdata('message') ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-lg rounded-2xl overflow-hidden border border-gray-100">
        <table class="min-w-full leading-normal">
            <thead>
                <tr>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/education') ?>?sort=institution&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Institusi
                            <?php if($sort == 'institution'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/education') ?>?sort=level&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Jenjang
                            <?php if($sort == 'level'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/education') ?>?sort=start_year&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Tahun
                            <?php if($sort == 'start_year'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider text-right">
                        Aksi
                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php foreach ($educations as $education): ?>
                <tr class="hover:bg-gray-50 transition-colors duration-150">
                    <td class="px-6 py-4">
                        <p class="text-gray-900 font-bold"><?= esc($education['institution']) ?></p>
                        <p class="text-gray-500 text-xs mt-0.5"><?= esc($education['major']) ?></p>
                    </td>
                    <td class="px-6 py-4">
                        <span class="relative inline-block px-3 py-1 font-semibold text-green-900 leading-tight">
                            <span aria-hidden class="absolute inset-0 bg-green-200 opacity-50 rounded-full"></span>
                            <span class="relative text-xs"><?= esc($education['level']) ?></span>
                        </span>
                    </td>
                    <td class="px-6 py-4">
                        <span class="text-gray-600 text-sm font-mono bg-gray-100 px-2 py-1 rounded">
                            <?= esc($education['start_year']) ?> - <?= $education['end_year'] ? esc($education['end_year']) : 'Sekarang' ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex items-center justify-end space-x-3">
                            <a href="<?= base_url('admin/education/' . $education['id'] . '/edit') ?>" class="text-yellow-500 hover:text-yellow-600 bg-yellow-50 hover:bg-yellow-100 p-2 rounded-lg transition-all" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <button onclick="confirmDelete(<?= $education['id'] ?>, '<?= base_url('admin/education/' . $education['id'] . '/delete') ?>')" class="text-red-500 hover:text-red-600 bg-red-50 hover:bg-red-100 p-2 rounded-lg transition-all" title="Hapus">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex flex-col xs:flex-row items-center xs:justify-between">
             <?= $pager->links() ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
