<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold"><?= $title ?></h3>
        <a href="<?= base_url('admin/education') ?>" class="flex items-center text-gray-600 hover:text-indigo-600 transition-colors">
            <i class="fas fa-arrow-left mr-2"></i> Kembali
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
        <?php if(session()->getFlashdata('errors')): ?>
            <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r">
                <div class="font-bold mb-2"><i class="fas fa-exclamation-circle mr-2"></i> Ada Kesalahan:</div>
                <ul class="list-disc list-inside text-sm">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?= isset($education) ? base_url('admin/education/' . $education['id'] . '/update') : base_url('admin/education/create') ?>" method="post">
            <?= csrf_field() ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Institution -->
                <div class="mb-4">
                    <label for="institution" class="block text-gray-700 font-bold mb-2">Nama Institusi</label>
                    <input type="text" name="institution" id="institution" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($education) ? esc($education['institution']) : old('institution') ?>" required placeholder="Contoh: Universitas Gadjah Mada">
                </div>

                <!-- Level -->
                <div class="mb-4">
                    <label for="level" class="block text-gray-700 font-bold mb-2">Jenjang Pendidikan</label>
                    <select name="level" id="level" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
                        <?php $levels = ['SD', 'SMP', 'SMA/SMK', 'Diploma', 'Sarjana (S1)', 'Magister (S2)', 'Doktor (S3)']; ?>
                        <?php foreach($levels as $l): ?>
                            <option value="<?= $l ?>" <?= (isset($education) && $education['level'] == $l) ? 'selected' : '' ?>><?= $l ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Start Year -->
                <div class="mb-4">
                    <label for="start_year" class="block text-gray-700 font-bold mb-2">Tahun Mulai</label>
                    <input type="number" name="start_year" id="start_year" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($education) ? esc($education['start_year']) : old('start_year') ?>" required placeholder="YYYY">
                </div>

                <!-- End Year -->
                <div class="mb-4">
                    <label for="end_year" class="block text-gray-700 font-bold mb-2">Tahun Selesai (Kosongkan jika aktif)</label>
                    <input type="number" name="end_year" id="end_year" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($education) ? esc($education['end_year']) : old('end_year') ?>" placeholder="YYYY">
                </div>

                <!-- Major -->
                <div class="mb-4 md:col-span-2">
                    <label for="major" class="block text-gray-700 font-bold mb-2">Jurusan / Bidang Studi</label>
                    <input type="text" name="major" id="major" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($education) ? esc($education['major']) : old('major') ?>" placeholder="Contoh: Teknik Informatika">
                </div>

                <!-- Description -->
                <div class="mb-4 md:col-span-2">
                    <label for="description" class="block text-gray-700 font-bold mb-2">Deskripsi (Opsional)</label>
                    <textarea name="description" id="description" rows="3" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" placeholder="Detail tambahan..."><?= isset($education) ? esc($education['description']) : old('description') ?></textarea>
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="bg-primary hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                    <i class="fas fa-save mr-2"></i> Simpan Pendidikan
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
