<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="space-y-8">
    
    <!-- Welcome Banner -->
    <div class="bg-gradient-to-r from-gray-900 via-indigo-900 to-gray-900 rounded-2xl p-6 sm:p-8 relative overflow-hidden shadow-2xl group">
        <div class="absolute inset-0 bg-grid-white/5 opacity-50"></div>
        <div class="relative z-10 flex flex-col md:flex-row items-center justify-between gap-6">
            <div>
                <div class="flex items-center gap-3 mb-3">
                    <span class="px-3 py-1 bg-green-500/20 text-green-400 text-xs font-bold rounded-full animate-pulse">
                        <i class="fas fa-circle text-[8px] mr-1"></i>Online
                    </span>
                    <span class="text-gray-400 text-sm"><?= date('l, d F Y') ?></span>
                </div>
                <h2 class="text-2xl sm:text-3xl font-bold text-white mb-2">Halo, Admin! 👋</h2>
                <p class="text-gray-400 max-w-lg">Selamat datang kembali di panel kontrol. Kelola portofolio Anda dengan mudah dan profesional.</p>
            </div>
            <div class="flex gap-3">
                <a href="<?= base_url('admin/activity/new') ?>" class="px-5 py-3 bg-white/10 hover:bg-white/20 text-white font-medium rounded-xl transition-all duration-300 backdrop-blur-sm flex items-center gap-2 hover:-translate-y-1">
                    <i class="fas fa-plus"></i>
                    <span class="hidden sm:inline">Tambah Aktivitas</span>
                </a>
                <a href="<?= base_url('/') ?>" target="_blank" class="px-5 py-3 bg-primary hover:bg-indigo-600 text-white font-medium rounded-xl transition-all duration-300 shadow-lg shadow-primary/30 flex items-center gap-2 hover:-translate-y-1">
                    <i class="fas fa-external-link-alt"></i>
                    <span class="hidden sm:inline">Lihat Website</span>
                </a>
            </div>
        </div>
        <div class="absolute -right-10 -bottom-10 w-40 h-40 bg-primary/20 rounded-full blur-3xl group-hover:bg-primary/30 transition-colors duration-500"></div>
        <i class="fas fa-layer-group absolute -right-4 sm:-right-6 -bottom-4 sm:-bottom-6 text-7xl sm:text-9xl text-white opacity-5 transform -rotate-12 group-hover:rotate-0 transition-transform duration-500"></i>
    </div>

    <!-- Metric Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
        <!-- Metric Card: Profiles -->
        <div class="bg-white rounded-2xl p-5 sm:p-6 shadow-lg border border-gray-100 relative overflow-hidden group hover:-translate-y-1 hover:shadow-xl transition-all duration-300">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Total Profil</p>
                    <h3 class="text-3xl sm:text-4xl font-bold text-gray-800 mt-2 counter" data-target="<?= $counts['profiles'] ?>">0</h3>
                </div>
                <div class="p-3 sm:p-4 rounded-2xl bg-gradient-to-br from-indigo-500 to-indigo-600 text-white shadow-lg shadow-indigo-500/30 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-users text-xl sm:text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center gap-2">
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                    <i class="fas fa-arrow-up mr-1"></i>Aktif
                </span>
                <span class="text-gray-400 text-sm">Data tersedia</span>
            </div>
            <div class="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-indigo-500 to-indigo-600 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500 origin-left"></div>
        </div>

        <!-- Metric Card: Educations -->
        <div class="bg-white rounded-2xl p-5 sm:p-6 shadow-lg border border-gray-100 relative overflow-hidden group hover:-translate-y-1 hover:shadow-xl transition-all duration-300">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Riwayat Pendidikan</p>
                    <h3 class="text-3xl sm:text-4xl font-bold text-gray-800 mt-2 counter" data-target="<?= $counts['educations'] ?>">0</h3>
                </div>
                <div class="p-3 sm:p-4 rounded-2xl bg-gradient-to-br from-emerald-500 to-green-600 text-white shadow-lg shadow-emerald-500/30 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-graduation-cap text-xl sm:text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center gap-2">
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                    <i class="fas fa-check-circle mr-1"></i>Terverifikasi
                </span>
                <span class="text-gray-400 text-sm">Institusi</span>
            </div>
            <div class="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-emerald-500 to-green-600 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500 origin-left"></div>
        </div>

        <!-- Metric Card: Activities -->
        <div class="bg-white rounded-2xl p-5 sm:p-6 shadow-lg border border-gray-100 relative overflow-hidden group hover:-translate-y-1 hover:shadow-xl transition-all duration-300 sm:col-span-2 lg:col-span-1">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-sm font-medium text-gray-500 uppercase tracking-wider">Aktivitas Harian</p>
                    <h3 class="text-3xl sm:text-4xl font-bold text-gray-800 mt-2 counter" data-target="<?= $counts['activities'] ?>">0</h3>
                </div>
                <div class="p-3 sm:p-4 rounded-2xl bg-gradient-to-br from-pink-500 to-rose-600 text-white shadow-lg shadow-pink-500/30 group-hover:scale-110 transition-transform duration-300">
                    <i class="fas fa-calendar-day text-xl sm:text-2xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center gap-2">
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-pink-100 text-pink-800">
                    <i class="fas fa-clock mr-1"></i>Terkini
                </span>
                <span class="text-gray-400 text-sm">Kegiatan</span>
            </div>
            <div class="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-pink-500 to-rose-600 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500 origin-left"></div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-2 sm:grid-cols-4 gap-3 sm:gap-4">
        <a href="<?= base_url('admin/profile') ?>" class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 hover:shadow-md hover:-translate-y-1 transition-all duration-300 flex flex-col items-center gap-2 group">
            <div class="w-12 h-12 rounded-xl bg-blue-50 text-blue-600 flex items-center justify-center group-hover:bg-blue-600 group-hover:text-white transition-colors duration-300">
                <i class="fas fa-user text-xl"></i>
            </div>
            <span class="text-sm font-medium text-gray-700">Profil</span>
        </a>
        <a href="<?= base_url('admin/education') ?>" class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 hover:shadow-md hover:-translate-y-1 transition-all duration-300 flex flex-col items-center gap-2 group">
            <div class="w-12 h-12 rounded-xl bg-green-50 text-green-600 flex items-center justify-center group-hover:bg-green-600 group-hover:text-white transition-colors duration-300">
                <i class="fas fa-graduation-cap text-xl"></i>
            </div>
            <span class="text-sm font-medium text-gray-700">Pendidikan</span>
        </a>
        <a href="<?= base_url('admin/activity') ?>" class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 hover:shadow-md hover:-translate-y-1 transition-all duration-300 flex flex-col items-center gap-2 group">
            <div class="w-12 h-12 rounded-xl bg-pink-50 text-pink-600 flex items-center justify-center group-hover:bg-pink-600 group-hover:text-white transition-colors duration-300">
                <i class="fas fa-camera text-xl"></i>
            </div>
            <span class="text-sm font-medium text-gray-700">Aktivitas</span>
        </a>
        <a href="<?= base_url('/') ?>" target="_blank" class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 hover:shadow-md hover:-translate-y-1 transition-all duration-300 flex flex-col items-center gap-2 group">
            <div class="w-12 h-12 rounded-xl bg-purple-50 text-purple-600 flex items-center justify-center group-hover:bg-purple-600 group-hover:text-white transition-colors duration-300">
                <i class="fas fa-globe text-xl"></i>
            </div>
            <span class="text-sm font-medium text-gray-700">Website</span>
        </a>
    </div>

    <!-- Charts & Widgets Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Chart Section -->
        <div class="bg-white rounded-2xl p-5 sm:p-6 shadow-lg border border-gray-100">
            <h3 class="text-lg font-bold text-gray-800 mb-6 flex items-center">
                <div class="w-10 h-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center mr-3">
                    <i class="fas fa-chart-pie"></i>
                </div>
                Statistik Media Aktivitas
            </h3>
            <div class="relative h-56 sm:h-64">
                <canvas id="mediaChart"></canvas>
            </div>
            <div class="mt-6 flex justify-center gap-6">
                <div class="flex items-center gap-2">
                    <div class="w-3 h-3 rounded-full bg-indigo-500"></div>
                    <span class="text-sm text-gray-600">Foto (<?= $chart_data['photo'] ?>)</span>
                </div>
                <div class="flex items-center gap-2">
                    <div class="w-3 h-3 rounded-full bg-pink-500"></div>
                    <span class="text-sm text-gray-600">Video (<?= $chart_data['video'] ?>)</span>
                </div>
            </div>
        </div>

        <!-- Recent Activities Widget -->
        <div class="bg-white rounded-2xl p-5 sm:p-6 shadow-lg border border-gray-100">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-lg font-bold text-gray-800 flex items-center">
                    <div class="w-10 h-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center mr-3">
                        <i class="fas fa-history"></i>
                    </div>
                    Aktivitas Terbaru
                </h3>
                <a href="<?= base_url('admin/activity') ?>" class="text-sm text-primary font-medium hover:underline flex items-center gap-1 hover:gap-2 transition-all">
                    Lihat Semua <i class="fas fa-arrow-right text-xs"></i>
                </a>
            </div>
            
            <div class="space-y-3 max-h-72 overflow-y-auto pr-2">
                <?php if(!empty($recent_activities)): ?>
                    <?php foreach($recent_activities as $index => $activity): ?>
                    <div class="flex items-center p-3 hover:bg-gray-50 rounded-xl transition-all duration-300 border border-transparent hover:border-gray-100 group cursor-pointer" style="animation-delay: <?= $index * 100 ?>ms;">
                        <div class="flex-shrink-0 w-12 h-12 rounded-xl bg-gradient-to-br <?= $activity['media_type'] == 'photo' ? 'from-blue-400 to-blue-600' : ($activity['media_type'] == 'video' ? 'from-red-400 to-red-600' : 'from-gray-400 to-gray-600') ?> flex items-center justify-center text-white shadow-lg group-hover:scale-110 transition-transform duration-300">
                            <?php if($activity['media_type'] == 'photo'): ?>
                                <i class="fas fa-image"></i>
                            <?php elseif($activity['media_type'] == 'video'): ?>
                                <i class="fas fa-video"></i>
                            <?php else: ?>
                                <i class="fas fa-sticky-note"></i>
                            <?php endif; ?>
                        </div>
                        <div class="ml-4 flex-1 min-w-0">
                            <p class="text-sm font-semibold text-gray-800 truncate group-hover:text-primary transition-colors"><?= esc($activity['activity_name']) ?></p>
                            <p class="text-xs text-gray-500 mt-1 flex items-center gap-2">
                                <i class="far fa-clock"></i> <?= date('d M Y', strtotime($activity['date'])) ?>
                                <span class="px-2 py-0.5 bg-gray-100 rounded text-gray-600 capitalize"><?= $activity['media_type'] ?? 'Note' ?></span>
                            </p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-300 group-hover:text-primary transition-colors"></i>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-center py-12">
                        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-inbox text-2xl text-gray-400"></i>
                        </div>
                        <p class="text-gray-400">Belum ada aktivitas.</p>
                        <a href="<?= base_url('admin/activity/new') ?>" class="text-primary text-sm font-medium hover:underline mt-2 inline-block">
                            Tambah Aktivitas Pertama
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Counter Animation
    const counters = document.querySelectorAll('.counter');
    counters.forEach(counter => {
        const target = +counter.getAttribute('data-target');
        const increment = Math.max(1, target / 30);
        
        function updateCounter() {
            const current = +counter.innerText;
            if (current < target) {
                counter.innerText = Math.ceil(current + increment);
                setTimeout(updateCounter, 50);
            } else {
                counter.innerText = target;
            }
        }
        
        const observer = new IntersectionObserver(entries => {
            if (entries[0].isIntersecting) {
                updateCounter();
                observer.disconnect();
            }
        });
        observer.observe(counter);
    });

    // Chart
    const ctx = document.getElementById('mediaChart').getContext('2d');
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Foto', 'Video'],
            datasets: [{
                data: [<?= $chart_data['photo'] ?>, <?= $chart_data['video'] ?>],
                backgroundColor: ['#4F46E5', '#EC4899'],
                borderWidth: 0,
                hoverOffset: 12,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            cutout: '70%',
            animation: {
                animateRotate: true,
                animateScale: true
            }
        }
    });
</script>

<style>
    .bg-grid-white\/5 {
        background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
    }
</style>

<?= $this->endSection() ?>

