<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold">Aktivitas Harian</h3>
        <a href="<?= base_url('admin/activity/new') ?>" class="bg-primary hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
            <i class="fas fa-plus mr-2"></i> Tambah Data
        </a>
    </div>

    <!-- Filter & Search -->
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-center bg-white p-4 rounded-xl shadow-sm border border-gray-100">
        <form action="" method="get" class="flex w-full sm:w-auto relative group items-center gap-2">
            <!-- Filter Dropdown -->
            <select name="filter" onchange="this.form.submit()" class="border border-gray-200 rounded-lg py-2 px-4 focus:outline-none focus:ring-2 focus:ring-primary text-gray-600">
                <option value="">Semua Tipe</option>
                <option value="photo" <?= $filter == 'photo' ? 'selected' : '' ?>>Foto</option>
                <option value="video" <?= $filter == 'video' ? 'selected' : '' ?>>Video</option>
            </select>

            <div class="relative flex-grow">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400 group-focus-within:text-primary transition-colors"></i>
                </div>
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari aktivitas..." class="pl-10 pr-4 py-2 border border-gray-200 rounded-lg w-full sm:w-64 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
            </div>
            <button type="submit" class="bg-gray-100 text-gray-600 px-4 py-2 rounded-lg hover:bg-gray-200 transition-colors font-medium">Cari</button>
        </form>
    </div>

    <?php if(session()->getFlashdata('message')): ?>
        <div class="bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-r shadow-sm mb-6 flex items-center" role="alert">
            <i class="fas fa-check-circle mr-3 text-lg"></i>
            <span class="font-medium"><?= session()->getFlashdata('message') ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-lg rounded-2xl overflow-hidden border border-gray-100">
        <table class="min-w-full leading-normal">
            <thead>
                <tr>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/activity') ?>?sort=date&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Waktu
                            <?php if($sort == 'date'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/activity') ?>?sort=activity_name&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Aktivitas
                            <?php if($sort == 'activity_name'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        <a href="<?= base_url('admin/activity') ?>?sort=media_type&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&filter=<?= esc($filter) ?>" class="flex items-center hover:text-primary transition-colors">
                            Media
                            <?php if($sort == 'media_type'): ?>
                                <i class="fas fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i>
                            <?php else: ?>
                                <i class="fas fa-sort ml-1 text-gray-300"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider text-right">
                        Aksi
                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php foreach ($activities as $activity): ?>
                <tr class="hover:bg-gray-50 transition-colors duration-150">
                    <td class="px-6 py-4 whitespace-no-wrap">
                        <p class="text-gray-900 font-medium"><?= esc($activity['date']) ?></p>
                        <p class="text-gray-400 text-xs mt-0.5"><i class="far fa-clock mr-1"></i><?= esc($activity['time']) ?></p>
                    </td>
                    <td class="px-6 py-4">
                        <p class="text-gray-900 font-bold mb-1"><?= esc($activity['activity_name']) ?></p>
                        <p class="text-gray-500 text-xs leading-relaxed max-w-xs"><?= character_limiter(esc($activity['description']), 60) ?></p>
                    </td>
                    <td class="px-6 py-4">
                         <?php if($activity['media_path']): ?>
                            <?php if($activity['media_type'] == 'photo'): ?>
                                <div class="relative group w-12 h-12">
                                    <img src="<?= base_url($activity['media_path']) ?>" alt="" class="h-full w-full rounded-lg object-cover shadow-sm group-hover:shadow-md transition-shadow">
                                    <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition-all rounded-lg"></div>
                                </div>
                            <?php else: ?>
                                <div class="h-12 w-12 rounded-lg bg-gray-100 flex items-center justify-center text-gray-400">
                                    <i class="fas fa-video text-lg"></i>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="text-gray-300 text-xs italic">Tanpa Media</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex items-center justify-end space-x-3">
                            <a href="<?= base_url('admin/activity/' . $activity['id'] . '/edit') ?>" class="text-yellow-500 hover:text-yellow-600 bg-yellow-50 hover:bg-yellow-100 p-2 rounded-lg transition-all" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <button onclick="confirmDelete(<?= $activity['id'] ?>, '<?= base_url('admin/activity/' . $activity['id'] . '/delete') ?>')" class="text-red-500 hover:text-red-600 bg-red-50 hover:bg-red-100 p-2 rounded-lg transition-all" title="Hapus">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex flex-col xs:flex-row items-center xs:justify-between">
             <?= $pager->links() ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
