<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class MainSeeder extends Seeder
{
    public function run()
    {
        // User Admin
        $this->db->table('users')->insert([
            'username'      => 'admin',
            'email'         => 'admin@example.com',
            'password_hash' => password_hash('admin123', PASSWORD_DEFAULT),
            'created_at'    => date('Y-m-d H:i:s'),
            'updated_at'    => date('Y-m-d H:i:s'),
        ]);

        // Profile
        $this->db->table('profiles')->insert([
            'full_name'  => 'Muhamad Abdul Aziz',
            'birth_date' => '1995-05-15',
            'address'    => 'Jl. Teknologi No. 10, Jakarta',
            'phone'      => '081234567890',
            'email'      => 'muhamad.aziz@example.com',
            'bio'        => 'Seorang pengembang web yang berpengalaman dengan desain kreatif.',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        // Educations
        $data_edu = [
            [
                'institution' => 'SD Negeri 01 Jakarta',
                'level'       => 'SD',
                'start_year'  => '2001',
                'end_year'    => '2007',
                'major'       => '-',
                'description' => 'Lulus dengan predikat baik.',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Universitas Yatsi Madani',
                'level'       => 'Sarjana (S1)',
                'start_year'  => '2020',
                'end_year'    => null,
                'major'       => 'Teknik Informatika',
                'description' => 'Aktif dalam organisasi kemahasiswaan.',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ]
        ];
        $this->db->table('educations')->insertBatch($data_edu);

        // Activities
        $data_act = [
            [
                'date'          => date('Y-m-d'),
                'time'          => '08:00:00',
                'activity_name' => 'Jogging Pagi',
                'media_type'    => 'none',
                'description'   => 'Jogging di sekitar taman untuk menjaga kesehatan.',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'date'          => date('Y-m-d'),
                'time'          => '10:00:00',
                'activity_name' => 'Sesi Coding',
                'media_type'    => 'none',
                'description'   => 'Mengerjakan proyek CI4 baru.',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ]
        ];
        $this->db->table('activities')->insertBatch($data_act);

        // Certificates
        $data_cert = [
            [
                'title'       => 'Google Data Analytics',
                'issuer'      => 'Google',
                'issue_date'  => '2024-06-15',
                'credential_id' => 'GAD-12345-ABC',
                'credential_url' => 'https://www.credly.com/badges/example',
                'description' => 'Sertifikat analisis data profesional dari Google.',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'title'       => 'Web Development Bootcamp',
                'issuer'      => 'Dicoding Academy',
                'issue_date'  => '2024-01-20',
                'credential_id' => 'DIC-WEB-67890',
                'description' => 'Sertifikat kelulusan bootcamp pengembangan web.',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ]
        ];
        $this->db->table('certificates')->insertBatch($data_cert);
    }
}
