<?php

namespace App\Controllers;

use App\Models\ProfileModel;
use App\Models\EducationModel;
use App\Models\ActivityModel;
use App\Models\CertificateModel;

class Home extends BaseController
{
    public function index()
    {
        // Landing Page with Summary
        return view('frontend/home', [
            'title' => 'Beranda'
        ]);
    }

    public function profile()
    {
        $model = new ProfileModel();
        $certModel = new CertificateModel();
        
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        if($search){
             if (strlen($search) >= 3) {
                $model->groupStart()
                    ->like('full_name', $search)
                    ->orLike('bio', $search)
                ->groupEnd();
             }
        }

        $data = [
            'profiles' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'certificates' => $certModel->orderBy('issue_date', 'DESC')->findAll(),
            'search' => $search,
            'sort' => $sort,
            'order' => $order,
            'title' => 'Profil Saya'
        ];
        return view('frontend/profile', $data);
    }

    public function education()
    {
        $model = new EducationModel();

        $search = $this->request->getGet('search');
        $filter = $this->request->getGet('filter');
        $sort = $this->request->getGet('sort') ?? 'start_year';
        $order = $this->request->getGet('order') ?? 'DESC';

        if($search){
             if (strlen($search) >= 3) {
                $model->groupStart()
                    ->like('institution', $search)
                    ->orLike('major', $search)
                ->groupEnd();
             }
        }

        if ($filter) {
            $model->where('level', $filter);
        }

        $data = [
            'educations' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order,
            'title' => 'Riwayat Pendidikan'
        ];
        return view('frontend/education', $data);
    }

    public function activities()
    {
        $model = new ActivityModel();

        $search = $this->request->getGet('search');
        $filter = $this->request->getGet('filter');
        $sort = $this->request->getGet('sort') ?? 'date';
        $order = $this->request->getGet('order') ?? 'DESC';

        if($search){
             if (strlen($search) >= 3) {
                $model->groupStart()
                    ->like('activity_name', $search)
                    ->orLike('description', $search)
                ->groupEnd();
             }
        }

        if ($filter) {
            if ($filter == 'photo') {
                $model->where('media_type', 'photo');
            } elseif ($filter == 'video') {
                $model->where('media_type', 'video');
            }
        }

        $data = [
            'activities' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order,
            'title' => 'Aktivitas Saya'
        ];
        return view('frontend/activities', $data);
    }
}
