<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

// Auth Routes
$routes->get('/login', 'AuthController::index');
$routes->post('/auth/login', 'AuthController::login');
$routes->get('/logout', 'AuthController::logout');

// Frontend Routes
$routes->get('/', 'Home::index');
$routes->get('/profile', 'Home::profile');
$routes->get('/education', 'Home::education');
$routes->get('/activities', 'Home::activities');
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Admin\DashboardController::index');
    
    // Profile CRUD
    $routes->get('profile', 'Admin\ProfileController::index');
    $routes->get('profile/new', 'Admin\ProfileController::new');
    $routes->post('profile/create', 'Admin\ProfileController::create');
    $routes->get('profile/(:num)/edit', 'Admin\ProfileController::edit/$1');
    $routes->post('profile/(:num)/update', 'Admin\ProfileController::update/$1');
    $routes->get('profile/(:num)/delete', 'Admin\ProfileController::delete/$1');
    
    // Education CRUD
    $routes->get('education', 'Admin\EducationController::index');
    $routes->get('education/new', 'Admin\EducationController::new');
    $routes->post('education/create', 'Admin\EducationController::create');
    $routes->get('education/(:num)/edit', 'Admin\EducationController::edit/$1');
    $routes->post('education/(:num)/update', 'Admin\EducationController::update/$1');
    $routes->get('education/(:num)/delete', 'Admin\EducationController::delete/$1');
    
    // Activity CRUD
    $routes->get('activity', 'Admin\ActivityController::index');
    $routes->get('activity/new', 'Admin\ActivityController::new');
    $routes->post('activity/create', 'Admin\ActivityController::create');
    $routes->get('activity/(:num)/edit', 'Admin\ActivityController::edit/$1');
    $routes->post('activity/(:num)/update', 'Admin\ActivityController::update/$1');
    $routes->get('activity/(:num)/delete', 'Admin\ActivityController::delete/$1');
    
    // Certificate CRUD
    $routes->get('certificate', 'Admin\CertificateController::index');
    $routes->get('certificate/new', 'Admin\CertificateController::new');
    $routes->post('certificate/create', 'Admin\CertificateController::create');
    $routes->get('certificate/(:num)/edit', 'Admin\CertificateController::edit/$1');
    $routes->post('certificate/(:num)/update', 'Admin\CertificateController::update/$1');
    $routes->get('certificate/(:num)/delete', 'Admin\CertificateController::delete/$1');
});
