<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Manajemen Pendidikan</h1>
    <a href="/admin/education/new"
        class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded shadow transition">
        + Tambah Baru
    </a>
</div>

<div class="bg-white rounded-lg shadow overflow-hidden">
    <table class="w-full text-left border-collapse">
        <thead class="bg-gray-100 text-gray-700 uppercase text-sm">
            <tr>
                <th class="p-4 border-b">Jenjang</th>
                <th class="p-4 border-b">Nama Sekolah / Kampus</th>
                <th class="p-4 border-b">Tahun</th>
                <th class="p-4 border-b text-right">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($education as $item): ?>
                <tr class="hover:bg-gray-50">
                    <td class="p-4 border-b font-medium text-purple-600"><?= esc($item['level']) ?></td>
                    <td class="p-4 border-b"><?= esc($item['school_name']) ?></td>
                    <td class="p-4 border-b"><?= esc($item['start_year']) ?> - <?= esc($item['end_year']) ?></td>
                    <td class="p-4 border-b text-right space-x-2">
                        <a href="/admin/education/<?= $item['id'] ?>/edit"
                            class="text-blue-600 hover:text-blue-800 font-medium">Edit</a>
                        <form action="/admin/education/<?= $item['id'] ?>" method="post" class="inline-block"
                            onsubmit="return confirm('Yakin hapus?');">
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit"
                                class="text-red-600 hover:text-red-800 font-medium bg-transparent border-0 cursor-pointer">Hapus</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php if (empty($education)): ?>
        <div class="p-8 text-center text-gray-500">Data tidak ditemukan.</div>
    <?php endif; ?>
</div>

<div class="mt-6 flex justify-center">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>