<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run()
    {
        $data = [
            'username' => 'aul',
            'password' => password_hash('aul', PASSWORD_DEFAULT),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // Check if user exists to avoid duplicates
        $db = \Config\Database::connect();
        $builder = $db->table('users');
        
        // Remove old user if exists
        $builder->where('username', 'vanny')->delete();
        
        $exists = $builder->where('username', 'aul')->countAllResults();

        if ($exists == 0) {
            $builder->insert($data);
        }
    }
}
