<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ActivitySeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'date' => date('Y-m-d'),
                'time' => '07:00:00',
                'activity_name' => 'Jogging Pagi',
                'media_path' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'date' => date('Y-m-d'),
                'time' => '09:00:00',
                'activity_name' => 'Belajar Coding (CodeIgniter 4)',
                'media_path' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'date' => date('Y-m-d'),
                'time' => '13:00:00',
                'activity_name' => 'Mengerjakan Tugas Kuliah',
                'media_path' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'date' => date('Y-m-d'),
                'time' => '19:00:00',
                'activity_name' => 'Diskusi Tim Proyek',
                'media_path' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        // Check if data exists
        $db = \Config\Database::connect();
        $builder = $db->table('daily_activities');
        
        // Clear table first to avoid duplicates/mess
        $builder->emptyTable();
        
        $builder->insertBatch($data);
    }
}
