<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddFieldsToBiodata extends Migration
{
    public function up()
    {
        $fields = [
            'birth_date' => [
                'type' => 'DATE',
                'null' => true,
                'after' => 'email',
            ],
            'last_education' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
                'after' => 'birth_date',
            ],
        ];

        $this->forge->addColumn('biodata', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('biodata', ['birth_date', 'last_education']);
    }
}
