<?php

namespace App\Controllers;

use App\Models\ActivityModel;
use App\Models\BiodataModel;
use App\Models\EducationModel;

class Home extends BaseController
{
    public function index()
    {
        return view('frontend/home', [
            'title' => 'Beranda',
            'active_tab' => 'home'
        ]);
    }

    public function activities()
    {
        $model = new ActivityModel();
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'date';
        $order = $this->request->getGet('order') ?? 'DESC';

        if ($search) {
            $model->like('activity_name', $search)->orLike('date', $search);
        }

        $data = [
            'activities' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'title' => 'Aktivitas Harian',
            'active_tab' => 'activities'
        ];

        return view('frontend/activities', $data);
    }

    public function biodata()
    {
        $model = new BiodataModel();
        $search = $this->request->getGet('search');

        if ($search) {
            $model->like('name', $search)->orLike('summary', $search);
        }

        $data = [
            'biodata' => $model->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'title' => 'Biodata',
            'active_tab' => 'biodata'
        ];

        return view('frontend/biodata', $data);
    }

    public function education()
    {
        $model = new EducationModel();
        $search = $this->request->getGet('search');

        if ($search) {
            $model->like('school_name', $search)->orLike('level', $search);
        }

        $data = [
            'education' => $model->orderBy('start_year', 'DESC')->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'title' => 'Riwayat Pendidikan',
            'active_tab' => 'education'
        ];

        return view('frontend/education', $data);
    }
}
