<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class Biodata extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = $this->biodataModel;

        if ($search) {
            $model->like('name', $search)
                ->orLike('email', $search);
        }

        $data = [
            'biodata' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order,
        ];

        return view('admin/biodata/index', $data);
    }

    public function new()
    {
        return view('admin/biodata/create');
    }

    public function create()
    {
        $rules = [
            'name' => 'required',
            'email' => 'required|valid_email',
        ];

        // Handle File Upload
        $file = $this->request->getFile('photo');
        $fileName = null;

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/biodata', $fileName);
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'address' => $this->request->getPost('address'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'summary' => $this->request->getPost('summary'),
            'photo' => $fileName,
        ];

        if (!$this->biodataModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->biodataModel->errors());
        }

        return redirect()->to('/admin/biodata')->with('message', 'Biodata created successfully');
    }

    public function edit($id = null)
    {
        $data['biodata'] = $this->biodataModel->find($id);
        if (!$data['biodata']) {
            return redirect()->to('/admin/biodata')->with('error', 'Biodata not found');
        }
        return view('admin/biodata/edit', $data);
    }

    public function update($id = null)
    {
        $file = $this->request->getFile('photo');
        $data = [
            'id' => $id,
            'name' => $this->request->getPost('name'),
            'address' => $this->request->getPost('address'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
            'summary' => $this->request->getPost('summary'),
        ];

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/biodata', $fileName);
            $data['photo'] = $fileName;
        }

        if (!$this->biodataModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->biodataModel->errors());
        }

        return redirect()->to('/admin/biodata')->with('message', 'Biodata updated successfully');
    }

    public function delete($id = null)
    {
        $this->biodataModel->delete($id);
        return redirect()->to('/admin/biodata')->with('message', 'Biodata deleted successfully');
    }
}
