<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login Admin</title>
    <link rel="stylesheet" href="<?= base_url('css/style.css?v=' . time()) ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body class="login-body">

<div class="login-container">

    <!-- LEFT -->
    <div class="login-form">
        <h2>Admin Login</h2>

        <?php if (session()->getFlashdata('error')) : ?>
            <div style="color: #ff4d61; background: rgba(255, 77, 97, 0.1); padding: 10px; border-radius: 8px; margin-bottom: 20px; font-size: 14px;">
                <i class="fas fa-exclamation-circle"></i> <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form method="post" action="<?= base_url('/login') ?>">
            <input type="email" name="email" placeholder="Email admin" required>
            
            <div class="password-wrapper">
                <input type="password" name="password" id="passwordInput" placeholder="Password" required>
                <i class="fas fa-eye-slash" id="togglePassword"></i>
            </div>

            <button type="submit">SIGN IN</button>
        </form>
    </div>

    <!-- SCRIPT TOGGLE JS -->
    <script>
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#passwordInput');

        togglePassword.addEventListener('click', function () {
            // Toggle the type attribute
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            
            // Toggle the eye icon
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });
    </script>

    <!-- RIGHT -->
    <div class="login-side">
        <h2>Hello, Abelia!</h2>
        <p>
            Silahkan masuk untuk mengelola konten<br>
            pendidikan dan aktivitas.
        </p>
    </div>

</div>

</body>
</html>
