<?= $this->include('layout/header') ?>

<!-- WRAPPER MODERN -->
<div class="activity-modern-container">
    <div class="glow-bg-act"></div>

    <!-- HERO SECTION -->
    <div class="activity-hero-modern">
        <div class="hero-content">
            <h1>Aktivitas <br> <span class="text-gradient">Selalu Bergerak</span></h1>
            <p>Pada Halaman Ini Terdapat Beberapa Aktivitas Sehari-hari Saya Sebelum dan Saat Mengikuti Kelas Perkuliahan Baik Online atau pun Offline</p>
        </div>

        <div class="hero-stats">
            <div class="stat-box">
                <div class="stat-icon"><i class="fas fa-layer-group"></i></div>
                <div>
                    <span class="count"><?= $total_aktivitas ?></span>
                    <span class="label">Aktivitas</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon"><i class="fas fa-video"></i></div>
                <div>
                    <span class="count"><?= $total_video ?></span>
                    <span class="label">Video</span>
                </div>
            </div>
            <div class="stat-box">
                <div class="stat-icon"><i class="fas fa-camera"></i></div>
                <div>
                    <span class="count"><?= $total_foto ?></span>
                    <span class="label">Foto</span>
                </div>
            </div>
        </div>
    </div>

    <!-- FILTER BAR -->
    <div class="filter-island-wrapper">
        <form action="<?= base_url('/aktivitas') ?>" method="get" class="filter-glass-bar">
            <!-- SEARCH -->
            <div class="filter-group search">
                <i class="fas fa-search"></i>
                <input type="text" name="keyword" placeholder="Cari momen..." value="<?= esc(request()->getGet('keyword')) ?>">
            </div>
            
            <div class="filter-divider"></div>

            <!-- TANGGAL -->
            <div class="filter-group">
                <i class="far fa-calendar-alt"></i>
                <input type="text" name="tanggal" onfocus="(this.type='date')" onblur="(this.type='text')" placeholder="Pilih Tanggal" value="<?= esc(request()->getGet('tanggal')) ?>">
            </div>

            <!-- JAM (WAKTU) -->
            <div class="filter-group">
                <i class="far fa-clock"></i>
                <input type="text" name="waktu" onfocus="(this.type='time')" onblur="(this.type='text')" placeholder="Pilih Jam" value="<?= esc(request()->getGet('waktu')) ?>">
            </div>

            <!-- TIPE -->
            <div class="filter-group">
                <i class="fas fa-filter"></i>
                <select name="tipe">
                    <option value="" <?= request()->getGet('tipe') == '' ? 'selected' : '' ?>>Tipe</option>
                    <option value="Semua" <?= request()->getGet('tipe') == 'Semua' ? 'selected' : '' ?>>Semua</option>
                    <option value="Foto" <?= request()->getGet('tipe') == 'Foto' ? 'selected' : '' ?>>Foto</option>
                    <option value="Video" <?= request()->getGet('tipe') == 'Video' ? 'selected' : '' ?>>Video</option>
                </select>
            </div>

            <!-- URUTAN -->
            <div class="filter-group">
                <i class="fas fa-sort-amount-down"></i>
                <select name="urutan">
                    <option value="Terbaru" <?= request()->getGet('urutan') == 'Terbaru' ? 'selected' : '' ?>>Terbaru</option>
                    <option value="Terlama" <?= request()->getGet('urutan') == 'Terlama' ? 'selected' : '' ?>>Terlama</option>
                </select>
            </div>

            <button type="submit" class="btn-filter-apply">
                <span>Terapkan</span>
                <i class="fas fa-arrow-right"></i>
            </button>
        </form>
    </div>

    <!-- GRID -->
    <section class="activity-grid-modern">
        <?php if(!empty($aktivitas)): ?>
            <?php foreach($aktivitas as $act): ?>
                <div class="immersive-card">
                    <div class="immersive-img">
                        <img src="<?= base_url('img/activity/' . esc($act['file'])) ?>" alt="<?= esc($act['judul']) ?>" onerror="this.src='https://via.placeholder.com/400x500?text=Activity'">
                    </div>
                    <div class="immersive-overlay"></div>
                    
                    <div class="immersive-badge" style="<?= $act['tipe'] == 'Video' ? 'background:rgba(255, 42, 66, 0.9); border:none;' : '' ?>">
                        <?= strtoupper(esc($act['tipe'])) ?>
                    </div>

                    <?php if($act['tipe'] == 'Video'): ?>
                        <div class="play-icon" style="position: absolute; top:50%; left:50%; transform:translate(-50%, -50%); color:#fff; font-size:30px; z-index:5;"><i class="fas fa-play"></i></div>
                    <?php endif; ?>

                    <div class="immersive-body">
                        <span class="immersive-date"><i class="far fa-clock"></i> <?= date('d M Y', strtotime($act['tanggal'])) ?> • <?= date('H:i', strtotime($act['waktu'])) ?></span>
                        <h3 class="immersive-title"><?= esc($act['judul']) ?></h3>
                        <p class="immersive-desc"><?= esc($act['deskripsi']) ?></p>
                        <a href="javascript:void(0)" 
                           class="immersive-link btn-preview" 
                           data-judul="<?= esc($act['judul']) ?>" 
                           data-tanggal="<?= date('d M Y', strtotime($act['tanggal'])) ?>" 
                           data-waktu="<?= date('H:i', strtotime($act['waktu'])) ?>" 
                           data-deskripsi="<?= esc($act['deskripsi']) ?>" 
                           data-file="<?= base_url('img/activity/' . esc($act['file'])) ?>"
                           data-tipe="<?= esc($act['tipe']) ?>">
                           Baca selengkapnya <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p style="color: #666; font-style: italic;">Belum ada aktivitas yang ditambahkan.</p>
        <?php endif; ?>
    </section>

</div>
</div>

<!-- MODAL OVERLAY -->
<div class="modal-overlay" id="activityModal">
    <div class="modal-content">
        <div class="close-modal" id="closeModal">
            <i class="fas fa-times"></i>
        </div>
        <div class="modal-body">
            <div class="modal-visual" id="modalVisual">
                <!-- Image or Video will be injected here -->
            </div>
            <div class="modal-info">
                <div class="modal-badge" id="modalBadge">TIPE</div>
                <div class="modal-date" id="modalDate">
                    <i class="far fa-clock"></i> <span id="spanTanggal">TANGGAL</span> • <span id="spanWaktu">JAM</span>
                </div>
                <h2 id="modalTitle">JUDUL AKTIVITAS</h2>
                <p class="modal-desc" id="modalDesc">
                    DESKRIPSI LENGKAP
                </p>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('activityModal');
    const closeModal = document.getElementById('closeModal');
    const previewButtons = document.querySelectorAll('.btn-preview');

    const modalVisual = document.getElementById('modalVisual');
    const modalBadge = document.getElementById('modalBadge');
    const spanTanggal = document.getElementById('spanTanggal');
    const spanWaktu = document.getElementById('spanWaktu');
    const modalTitle = document.getElementById('modalTitle');
    const modalDesc = document.getElementById('modalDesc');

    previewButtons.forEach(btn => {
        btn.addEventListener('click', function() {
            const data = this.dataset;
            
            // Populate Modal
            modalBadge.textContent = data.tipe;
            spanTanggal.textContent = data.tanggal;
            spanWaktu.textContent = data.waktu;
            modalTitle.textContent = data.judul;
            modalDesc.textContent = data.deskripsi;

            // Handle Visual (Image or Video)
            if (data.tipe.toLowerCase() === 'video') {
                modalVisual.innerHTML = `<video src="${data.file}" controls autoplay></video>`;
                modalBadge.style.background = 'rgba(255, 42, 66, 0.9)';
            } else {
                modalVisual.innerHTML = `<img src="${data.file}" alt="${data.judul}">`;
                modalBadge.style.background = 'var(--marun)';
            }

            // Show Modal
            modal.classList.add('active');
            document.body.style.overflow = 'hidden'; // Prevent scroll
        });
    });

    // Close Modal
    function hideModal() {
        modal.classList.remove('active');
        document.body.style.overflow = '';
        // Stop video if playing
        const video = modalVisual.querySelector('video');
        if (video) video.pause();
    }

    closeModal.addEventListener('click', hideModal);
    
    // Close on click outside
    modal.addEventListener('click', function(e) {
        if (e.target === modal) hideModal();
    });

    // Close on Esc key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && modal.classList.contains('active')) hideModal();
    });
});
</script>

<?= $this->include('layout/footer') ?>
