<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>

<div class="page-header-admin">
    <h1 class="page-title">Edit Pendidikan</h1>
    <a href="<?= base_url('/admin/pendidikan') ?>" class="btn-add" style="background: #333;">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<form action="<?= base_url('/admin/pendidikan/update/' . $edu['id']) ?>" method="post" enctype="multipart/form-data" class="admin-form-container">
    
    <div class="form-group">
        <label class="form-label">Nama Sekolah / Universitas</label>
        <input type="text" name="sekolah" value="<?= esc($edu['sekolah']) ?>" required class="admin-input">
    </div>

    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
        <div>
            <label class="form-label">Jenjang</label>
            <select name="jenjang" class="admin-input">
                <option value="S3" <?= $edu['jenjang'] == 'S3' ? 'selected' : '' ?>>S3</option>
                <option value="S2" <?= $edu['jenjang'] == 'S2' ? 'selected' : '' ?>>S2</option>
                <option value="S1" <?= $edu['jenjang'] == 'S1' ? 'selected' : '' ?>>S1</option>
                <option value="SMA" <?= $edu['jenjang'] == 'SMA' ? 'selected' : '' ?>>SMA</option>
                <option value="SMP" <?= $edu['jenjang'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SD" <?= $edu['jenjang'] == 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="TK" <?= $edu['jenjang'] == 'TK' ? 'selected' : '' ?>>TK</option>
            </select>
        </div>
        <div>
            <label class="form-label">Jurusan (Optional)</label>
            <input type="text" name="jurusan" value="<?= esc($edu['jurusan']) ?>" class="admin-input">
        </div>
    </div>

    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px;">
        <div>
            <label class="form-label">Tahun Mulai</label>
            <input type="number" name="tahun_mulai" value="<?= esc($edu['tahun_mulai']) ?>" required class="admin-input">
        </div>
        <div>
            <label class="form-label">Tahun Selesai</label>
            <input type="text" name="tahun_selesai" value="<?= esc($edu['tahun_selesai']) ?>" required class="admin-input">
        </div>
    </div>

    <div class="form-group" style="margin-bottom: 30px;">
        <label class="form-label">Ganti Logo (Biarkan kosong jika tidak diubah)</label>
        <div style="display: flex; gap: 10px; align-items: center;">
            <img src="<?= base_url('img/pendidikan/' . $edu['logo']) ?>" 
                 style="width: 60px; height: 60px; object-fit: cover; border-radius: 8px; border: 1px solid #333;"
                 onerror="this.src='https://via.placeholder.com/60x60?text=No+Img'">
            <input type="file" name="logo" class="admin-input" style="flex: 1;">
        </div>
    </div>

    <div style="display: flex; justify-content: center; margin-top: 10px;">
        <button type="submit" class="btn-add" style="padding: 14px 40px;">Update Data</button>
    </div>

</form>

<?= $this->endSection() ?>
