<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard | MyPortfolio</title>
    <link rel="stylesheet" href="<?= base_url('css/style.css?v=' . time()) ?>">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        /* INLINE ADMIN STYLES FOR NOW, MOVE TO CSS LATER */
        .admin-wrapper {
            display: flex;
            min-height: 100vh;
            background: #050505;
        }
        .admin-sidebar {
            width: 250px;
            background: #0f0f0f;
            border-right: 1px solid #222;
            padding: 30px 20px;
            flex-shrink: 0;
        }
        .admin-content {
            flex: 1;
            padding: 40px;
            overflow-y: auto;
        }
        .admin-logo {
            font-size: 24px;
            font-weight: 800;
            background: linear-gradient(90deg, #ff4d61, #fff);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 40px;
            display: block;
            text-decoration: none;
        }
        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            color: #888;
            text-decoration: none;
            padding: 12px 15px;
            border-radius: 12px;
            margin-bottom: 5px;
            transition: 0.3s;
            font-weight: 500;
        }
        .nav-link.active, .nav-link:hover {
            background: rgba(164, 22, 42, 0.1);
            color: #ff4d61;
        }
        .nav-link i { width: 20px; text-align: center; }
        .page-header-admin {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        .page-title {
            font-size: 28px;
            color: #fff;
            font-weight: 700;
        }
        .btn-add {
            background: linear-gradient(135deg, #a4162a, #7a0f1b);
            color: #fff;
            padding: 10px 20px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        /* TABLE STYLES */
        .admin-table {
            width: 100%;
            border-collapse: collapse;
            background: #0f0f0f;
            border-radius: 16px;
            overflow: hidden;
        }
        .admin-table th, .admin-table td {
            padding: 15px 20px;
            text-align: left;
            border-bottom: 1px solid #222;
            color: #ddd;
        }
        .admin-table th {
            background: #151515;
            color: #888;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
        }
        .action-btn {
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 12px;
            text-decoration: none;
            margin-right: 5px;
            display: inline-block;
        }
        .btn-edit { background: rgba(255, 193, 7, 0.1); color: #ffc107; }
        .btn-delete { background: rgba(255, 77, 97, 0.1); color: #ff4d61; }

        /* ADMIN FORM STYLES */
        .admin-form-container {
            max-width: 600px;
            background: #0f0f0f;
            padding: 30px;
            border-radius: 20px;
            border: 1px solid #222;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            display: block;
            color: #888;
            margin-bottom: 8px;
            font-size: 14px;
        }
        .admin-input {
            width: 100%;
            padding: 12px;
            background: #1a1a1a !important;
            border: 1px solid #333;
            color: #fff !important;
            border-radius: 8px;
            font-family: inherit;
            transition: 0.3s;
            box-sizing: border-box;
        }
        .admin-input:focus {
            outline: none;
            border-color: #ff4d61;
            box-shadow: 0 0 10px rgba(255, 77, 97, 0.2);
        }
        
        /* Fix Browser Autofill */
        .admin-input:-webkit-autofill,
        .admin-input:-webkit-autofill:hover, 
        .admin-input:-webkit-autofill:focus, 
        .admin-input:-webkit-autofill:active {
            -webkit-background-clip: text;
            -webkit-text-fill-color: #ffffff !important;
            transition: background-color 5000s ease-in-out 0s;
            box-shadow: inset 0 0 20px 20px #1a1a1a !important;
        }
    </style>
</head>
<body>

<div class="admin-wrapper">
    <!-- SIDEBAR -->
    <aside class="admin-sidebar">
        <a href="<?= base_url('/admin/pendidikan') ?>" class="admin-logo">AdminPanel</a>
        <nav>
            <a href="<?= base_url('/admin/pendidikan') ?>" class="nav-link <?= strpos(uri_string(), 'pendidikan') !== false ? 'active' : '' ?>">
                <i class="fas fa-graduation-cap"></i> Pendidikan
            </a>
            <a href="<?= base_url('/admin/aktivitas') ?>" class="nav-link <?= strpos(uri_string(), 'aktivitas') !== false ? 'active' : '' ?>">
                <i class="fas fa-clock"></i> Aktivitas
            </a>
            <a href="<?= base_url('/') ?>" class="nav-link" target="_blank">
                <i class="fas fa-external-link-alt"></i> Lihat Website
            </a>
            <a href="<?= base_url('/logout') ?>" class="nav-link" style="margin-top: 40px; color: #ff4d61;">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </nav>
    </aside>

    <!-- CONTENT -->
    <main class="admin-content">
        <?= $this->renderSection('content') ?>
    </main>
</div>

</body>
</html>
