<?= $this->include('layout/header') ?>

<section class="page-header">
    <h1>Pendidikan</h1>
    <p>Riwayat pendidikan formal yang telah saya tempuh</p>
</section>

<!-- WRAPPER MODERN -->
<div class="education-modern-container">

    <div class="glow-bg-edu"></div>

    <!-- FILTER BAR GLASS -->
    <div class="filter-island-wrapper">
        <form method="get" class="filter-glass-bar">
            <div class="filter-group search">
                <i class="fas fa-search"></i>
                <input type="text" name="q" placeholder="Cari sekolah atau jurusan..." value="<?= esc($_GET['q'] ?? '') ?>">
            </div>

            <div class="filter-group">
                <i class="fas fa-filter"></i>
                <select name="jenjang">
                    <option value="Semua">Semua Jenjang</option>
                    <?php foreach (['S3', 'S2', 'S1', 'SMA', 'SMP', 'SD', 'TK'] as $j): ?>
                        <option value="<?= $j ?>" <?= ($_GET['jenjang'] ?? '') === $j ? 'selected' : '' ?>>
                            <?= $j ?>
                        </option>
                    <?php endforeach ?>
                </select>
            </div>

            <div class="filter-group">
                <i class="fas fa-sort-amount-down"></i>
                <select name="urut">
                    <option value="desc" <?= ($_GET['urut'] ?? '') === 'desc' ? 'selected' : '' ?>>Terbaru (Lulus)</option>
                    <option value="asc" <?= ($_GET['urut'] ?? '') === 'asc' ? 'selected' : '' ?>>Terlama (Masuk)</option>
                </select>
            </div>

            <button type="submit" class="btn-filter-apply">
                <i class="fas fa-check"></i> <span>Terapkan Filter</span>
            </button>
        </form>
    </div>

    <!-- GRID PENDIDIKAN MODERN -->
    <section class="education-grid-modern">
        <?php if (!empty($pendidikan)): ?>
            <?php foreach ($pendidikan as $edu): ?>
                <div class="edu-card-modern" data-jenjang="<?= esc($edu['jenjang']) ?>">
                    
                    <!-- BADGE -->
                    <div class="edu-badge-corner"><?= esc($edu['jenjang']) ?></div>

                    <div class="edu-visual">
                        <div class="logo-circle">
                            <img src="<?= base_url('img/pendidikan/' . esc($edu['logo'])) ?>" 
                                 alt="<?= esc($edu['sekolah']) ?>"
                                 onerror="this.src='https://via.placeholder.com/80x80?text=Logo'">
                        </div>
                    </div>

                    <div class="edu-info">
                        <h3><?= esc($edu['sekolah']) ?></h3>
                        <p class="jurusan"><?= esc($edu['jurusan']) ?></p>
                        
                        <div class="edu-meta">
                            <span class="year">
                                <i class="far fa-calendar-alt"></i> 
                                <?= esc($edu['tahun_mulai']) ?> – <?= esc($edu['tahun_selesai']) ?>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endforeach ?>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-search"></i>
                <p>Data pendidikan tidak ditemukan.</p>
            </div>
        <?php endif ?>
    </section>

    <!-- PAGINATION -->
    <div class="pagination-modern">
        <?= $pager->links('default', 'default_full') ?>
    </div>

</div>

<?= $this->include('layout/footer') ?>
