<?php

namespace App\Controllers;

use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    public function index()
    {
        $model = new PendidikanModel();

        // Ambil input GET
        $keyword = $this->request->getGet('q');
        $jenjang = $this->request->getGet('jenjang');
        $urut    = $this->request->getGet('urut') ?? 'desc';

        // Query dasar
        $builder = $model;

        // FILTER SEARCH
        if ($keyword) {
            $builder = $builder->groupStart()
                ->like('sekolah', $keyword)
                ->orLike('jurusan', $keyword)
                ->groupEnd();
        }

        // FILTER JENJANG
        if ($jenjang && $jenjang !== 'Semua') {
            $builder = $builder->where('jenjang', $jenjang);
        }

        // SORTING
        $builder = $builder->orderBy('tahun_selesai', $urut);

        // PAGINATION
        $data['pendidikan'] = $builder->paginate(6);
        $data['pager']      = $model->pager;

       return view('pendidikan/index', $data);

    }
}
