<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitas;

    public function __construct()
    {
        $this->aktivitas = new AktivitasModel();
    }

    // ===============================
    // HALAMAN AKTIVITAS (FRONTEND)
    // ===============================
    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $tanggal = $this->request->getGet('tanggal');
        $waktu   = $this->request->getGet('waktu');
        $tipe    = $this->request->getGet('tipe');
        $urutan  = $this->request->getGet('urutan') ?? 'Terbaru';

        $builder = $this->aktivitas;

        if ($keyword) {
            $builder->like('judul', $keyword);
        }

        if ($tanggal) {
            $builder->where('tanggal', $tanggal);
        }

        if ($waktu) {
            $builder->like('waktu', $waktu);
        }

        if ($tipe && $tipe !== 'Semua') {
            $builder->where('tipe', $tipe);
        }

        if ($urutan === 'Terlama') {
            $builder->orderBy('tanggal', 'ASC')->orderBy('waktu', 'ASC');
        } else {
            $builder->orderBy('tanggal', 'DESC')->orderBy('waktu', 'DESC');
        }

        $data['aktivitas'] = $builder->findAll();

        // Hitung total data secara dinamis
        $data['total_aktivitas'] = $this->aktivitas->countAllResults();
        $data['total_foto']      = $this->aktivitas->where('tipe', 'Foto')->countAllResults();
        $data['total_video']     = $this->aktivitas->where('tipe', 'Video')->countAllResults();

        return view('aktivitas/index', $data);
    }
}
