<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikanModel;

    public function __construct()
    {
        $this->pendidikanModel = new PendidikanModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Kelola Pendidikan',
            'pendidikan' => $this->pendidikanModel->findAll()
        ];
        return view('admin/pendidikan/index', $data);
    }

    public function create()
    {
        $data = ['title' => 'Tambah Pendidikan'];
        return view('admin/pendidikan/create', $data);
    }

    public function store()
    {
        if (!$this->validate([
            'sekolah' => 'required',
            'jenjang' => 'required',
            'tahun_mulai' => 'required|numeric',
            'tahun_selesai' => 'required',
            'logo' => 'uploaded[logo]|max_size[logo,2048]|is_image[logo]|mime_in[logo,image/jpg,image/jpeg,image/png]'
        ])) {
            return redirect()->to('/admin/pendidikan/create')->withInput();
        }

        $fileLogo = $this->request->getFile('logo');
        $namaLogo = $fileLogo->getRandomName();
        $fileLogo->move('img/pendidikan', $namaLogo);

        $this->pendidikanModel->save([
            'sekolah' => $this->request->getPost('sekolah'),
            'jurusan' => $this->request->getPost('jurusan'),
            'jenjang' => $this->request->getPost('jenjang'),
            'tahun_mulai' => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'logo' => $namaLogo
        ]);

        return redirect()->to('/admin/pendidikan')->with('success', 'Data pendidikan berhasil ditambahkan');
    }

    public function edit($id)
    {
        $data = [
            'title' => 'Edit Pendidikan',
            'edu' => $this->pendidikanModel->find($id)
        ];
        return view('admin/pendidikan/edit', $data);
    }

    public function update($id)
    {
        $edu = $this->pendidikanModel->find($id);
        $fileLogo = $this->request->getFile('logo');

        if ($fileLogo->getError() == 4) {
            $namaLogo = $edu['logo'];
        } else {
            $namaLogo = $fileLogo->getRandomName();
            $fileLogo->move('img/pendidikan', $namaLogo);
            if ($edu['logo'] != 'default.png' && file_exists('img/pendidikan/' . $edu['logo'])) {
                unlink('img/pendidikan/' . $edu['logo']);
            }
        }

        $this->pendidikanModel->update($id, [
            'sekolah' => $this->request->getPost('sekolah'),
            'jurusan' => $this->request->getPost('jurusan'),
            'jenjang' => $this->request->getPost('jenjang'),
            'tahun_mulai' => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'logo' => $namaLogo
        ]);

        return redirect()->to('/admin/pendidikan')->with('success', 'Data pendidikan berhasil diperbarui');
    }

    public function delete($id)
    {
        $edu = $this->pendidikanModel->find($id);
        if ($edu['logo'] != 'default.png' && file_exists('img/pendidikan/' . $edu['logo'])) {
            unlink('img/pendidikan/' . $edu['logo']);
        }

        $this->pendidikanModel->delete($id);
        return redirect()->to('/admin/pendidikan')->with('success', 'Data pendidikan berhasil dihapus');
    }
}
