<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

class Pager extends BaseConfig
{
    /**
     * --------------------------------------------------------------------------
     * Templates
     * --------------------------------------------------------------------------
     *
     * Pagination links are rendered using view templates.
     * Each template is referenced by an alias.
     *
     * Inside each template:
     * - $pager       → Pager instance
     * - $pagerGroup  → Pagination group
     *
     * @var array<string, string>
     */
    public array $templates = [
        // Default CodeIgniter templates
        'default_full'   => 'CodeIgniter\Pager\Views\default_full',
        'default_simple' => 'CodeIgniter\Pager\Views\default_simple',
        'default_head'   => 'CodeIgniter\Pager\Views\default_head',

        // Custom template (Bootstrap / custom style)
        'bootstrap'      => 'App\Views\Pagers\bootstrap',
    ];

    /**
     * --------------------------------------------------------------------------
     * Items Per Page
     * --------------------------------------------------------------------------
     *
     * Default number of items shown per page.
     */
    public int $perPage = 6; // ideal untuk grid pendidikan & aktivitas
}
